/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.i18nbinder.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.i18nbinder.grouping.FileGroup;
import org.omnaest.i18nbinder.grouping.FileGroupToPropertiesAdapter;
import org.omnaest.i18nbinder.grouping.FileGrouper;
import org.omnaest.i18nbinder.internal.LocaleFilter;
import org.omnaest.i18nbinder.internal.Logger;
import org.omnaest.i18nbinder.internal.XLSFile;
import org.omnaest.utils.propertyfile.PropertyFile;
import org.omnaest.utils.propertyfile.content.PropertyMap;
import org.omnaest.utils.propertyfile.content.element.Property;

public class ModifierHelper {
    public static final String GROUPING_PATTERN_REPLACEMENT_PATTERN_STRING = "{locale}";
    public static Logger logger = new Logger(){

        @Override
        public void info(String message) {
        }
    };

    public static void writeXLSFileContentToPropertyFiles(File file, String fileEncoding, LocaleFilter localeFilter, boolean deletePropertiesWithBlankValue, boolean useJavaStyleUnicodeEscaping) {
        if (XLSFile.isXLSFile(file)) {
            XLSFile xlsFile = new XLSFile(file);
            xlsFile.load();
            List<XLSFile.TableRow> tableRowList = xlsFile.getTableRowList();
            ArrayList<String> missingPropertyInformationList = new ArrayList<String>();
            ArrayList localeList = new ArrayList();
            XLSFile.TableRow tableRow = tableRowList.get(0);
            localeList.addAll(tableRow.subList(2, tableRow.size()));
            localeList.remove(null);
            for (String locale : new ArrayList(localeList)) {
                if (localeFilter.isLocaleAccepted(locale)) continue;
                localeList.remove(locale);
            }
            FilenameToPropertyKeyToValueMap filenameToPropertyKeyToValueMap = new FilenameToPropertyKeyToValueMap();
            for (XLSFile.TableRow tableRow2 : tableRowList.subList(1, tableRowList.size())) {
                String fileNameLocaleIndependent = (String)tableRow2.get(0);
                String propertyKey = (String)tableRow2.get(1);
                logger.info("Processing: " + fileNameLocaleIndependent + " " + propertyKey);
                int index = 2;
                for (String locale : localeList) {
                    try {
                        String value = (String)tableRow2.get(index++);
                        String fileName = fileNameLocaleIndependent.replaceAll(Pattern.quote(GROUPING_PATTERN_REPLACEMENT_PATTERN_STRING), locale);
                        if (!filenameToPropertyKeyToValueMap.containsKey(fileName)) {
                            filenameToPropertyKeyToValueMap.put(fileName, new PropertyKeyToValueMap());
                        }
                        PropertyKeyToValueMap propertyKeyToValueMap = (PropertyKeyToValueMap)filenameToPropertyKeyToValueMap.get(fileName);
                        if (value == null) continue;
                        propertyKeyToValueMap.put(propertyKey, value);
                    }
                    catch (Exception e) {
                        String message = "Missing property value within " + fileNameLocaleIndependent + " for locale " + locale + " and property" + propertyKey;
                        missingPropertyInformationList.add(message);
                    }
                }
            }
            for (String fileName : filenameToPropertyKeyToValueMap.keySet()) {
                PropertyKeyToValueMap propertyKeyToValueMap = (PropertyKeyToValueMap)filenameToPropertyKeyToValueMap.get(fileName);
                PropertyFile propertyFile = new PropertyFile(fileName);
                if (fileEncoding != null) {
                    propertyFile.setFileEncoding(fileEncoding);
                }
                propertyFile.setUseJavaStyleUnicodeEscaping(useJavaStyleUnicodeEscaping);
                propertyFile.load();
                PropertyMap propertyMap = propertyFile.getPropertyFileContent().getPropertyMap();
                boolean contentChanged = false;
                for (String propertyKey : propertyKeyToValueMap.keySet()) {
                    String value = (String)propertyKeyToValueMap.get(propertyKey);
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        Property property;
                        String[] values = value.split(Pattern.quote(FileGroupToPropertiesAdapter.MULTILINE_VALUES_SEPARATOR));
                        property = propertyMap.containsKey((Object)propertyKey) ? (property = propertyMap.get((Object)propertyKey)) : new Property();
                        property.setKey(propertyKey);
                        property.clearValues();
                        property.addAllValues(Arrays.asList(values));
                        propertyMap.put(property);
                        contentChanged = true;
                        continue;
                    }
                    if (!propertyMap.containsKey((Object)propertyKey) || !deletePropertiesWithBlankValue) continue;
                    propertyMap.remove((Object)propertyKey);
                    contentChanged = true;
                }
                if (!contentChanged) continue;
                propertyFile.store();
            }
            if (!missingPropertyInformationList.isEmpty()) {
                logger.info("Following property information were incomplete...");
                for (String missingPropertyInformation : missingPropertyInformationList) {
                    logger.info(missingPropertyInformation);
                }
            }
        }
    }

    public static XLSFile createXLSFileFromPropertyFiles(Set<File> propertyFileSet, String fileEncoding, LocaleFilter localeFilter, String fileNameLocaleGroupPattern, List<Integer> groupingPatternGroupingGroupIndexList, boolean useJavaStyleUnicodeEscaping) {
        XLSFile retval = null;
        if (propertyFileSet != null) {
            FileGrouper fileGrouper = new FileGrouper();
            try {
                if (fileNameLocaleGroupPattern != null) {
                    fileGrouper.setGroupingPatternString(fileNameLocaleGroupPattern);
                }
                if (groupingPatternGroupingGroupIndexList != null) {
                    fileGrouper.setGroupingPatternGroupingGroupIndexList(groupingPatternGroupingGroupIndexList);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            fileGrouper.setGroupingPatternReplacementToken(GROUPING_PATTERN_REPLACEMENT_PATTERN_STRING);
            fileGrouper.addAllFiles(propertyFileSet);
            Map<String, FileGroup> fileGroupIdentifierToFileGroupMap = fileGrouper.determineFileGroupIdentifierToFileGroupMap();
            ArrayList<FileGroupToPropertiesAdapter> fileGroupToPropertiesAdapterList = new ArrayList<FileGroupToPropertiesAdapter>();
            for (String fileGroupIdentifier : fileGroupIdentifierToFileGroupMap.keySet()) {
                FileGroup fileGroup = fileGroupIdentifierToFileGroupMap.get(fileGroupIdentifier);
                FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter = new FileGroupToPropertiesAdapter(fileGroup);
                fileGroupToPropertiesAdapter.setFileEncoding(fileEncoding);
                fileGroupToPropertiesAdapter.setUseJavaStyleUnicodeEscaping(useJavaStyleUnicodeEscaping);
                fileGroupToPropertiesAdapterList.add(fileGroupToPropertiesAdapter);
            }
            Collections.sort(fileGroupToPropertiesAdapterList, new Comparator<FileGroupToPropertiesAdapter>(){

                @Override
                public int compare(FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter1, FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter2) {
                    String fileGroupIdentifier1 = fileGroupToPropertiesAdapter1.getFileGroup().getFileGroupIdentifier();
                    String fileGroupIdentifier2 = fileGroupToPropertiesAdapter2.getFileGroup().getFileGroupIdentifier();
                    return fileGroupIdentifier1.compareTo(fileGroupIdentifier2);
                }
            });
            ArrayList localeList = new ArrayList();
            HashSet<String> localeSet = new HashSet<String>();
            for (FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter : fileGroupToPropertiesAdapterList) {
                localeSet.addAll(fileGroupToPropertiesAdapter.determineGroupTokenList());
            }
            localeList.addAll(localeSet);
            for (String locale : localeSet) {
                if (localeFilter.isLocaleAccepted(locale)) continue;
                localeList.remove(locale);
            }
            Collections.sort(localeList);
            XLSFile xlsFile = new XLSFile();
            List<XLSFile.TableRow> tableRowList = xlsFile.getTableRowList();
            XLSFile.TableRow tableRow = new XLSFile.TableRow();
            tableRow.add("File");
            tableRow.add("Property key");
            tableRow.addAll(localeList);
            tableRowList.add(tableRow);
            for (FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter : fileGroupToPropertiesAdapterList) {
                String fileGroupIdentifier = fileGroupToPropertiesAdapter.getFileGroup().getFileGroupIdentifier();
                logger.info("Processing: " + fileGroupIdentifier);
                ArrayList<String> propertyKeyList = new ArrayList<String>(fileGroupToPropertiesAdapter.determinePropertyKeySet());
                Collections.sort(propertyKeyList);
                for (String propertyKey : propertyKeyList) {
                    XLSFile.TableRow tableRow2 = new XLSFile.TableRow();
                    tableRow2.add(fileGroupIdentifier);
                    tableRow2.add(propertyKey);
                    for (String locale : localeList) {
                        String value = fileGroupToPropertiesAdapter.resolvePropertyValue(propertyKey, locale);
                        value = StringUtils.defaultString((String)value);
                        tableRow2.add(value);
                    }
                    tableRowList.add(tableRow2);
                }
            }
            retval = xlsFile;
        }
        return retval;
    }

    protected static class FilenameToPropertyKeyToValueMap
    extends HashMap<String, PropertyKeyToValueMap> {
        private static final long serialVersionUID = 8631992954259477041L;

        protected FilenameToPropertyKeyToValueMap() {
        }
    }

    protected static class PropertyKeyToValueMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 8625552580988921881L;

        protected PropertyKeyToValueMap() {
        }
    }
}

