/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.i18nbinder.test;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.omnaest.i18nbinder.test.i18nfacade.I18n;

public class I18nFacade {
    public final I18n I18n;

    public static void use(ResourceBasedTranslator resourceBasedTranslator) {
        Resource.resourceBasedTranslator = resourceBasedTranslator;
    }

    public I18nFacade(Locale locale) {
        this(locale, true);
    }

    public I18nFacade(Locale locale, boolean silentlyIgnoreMissingResourceException) {
        this.I18n = new I18n(locale, silentlyIgnoreMissingResourceException);
    }

    public static class Translator {
        private final String baseName;
        private final Locale locale;
        private final boolean silentlyIgnoreMissingResourceException;

        public Translator(String baseName, Locale locale) {
            this(baseName, locale, true);
        }

        public Translator(String baseName, Locale locale, boolean silentlyIgnoreMissingResourceException) {
            this.baseName = baseName;
            this.locale = locale;
            this.silentlyIgnoreMissingResourceException = silentlyIgnoreMissingResourceException;
        }

        public String translate(Locale locale, String key) {
            try {
                return Resource.resourceBasedTranslator.translate(this.baseName, key, locale);
            }
            catch (MissingResourceException e) {
                if (!this.silentlyIgnoreMissingResourceException) {
                    throw e;
                }
                return null;
            }
        }

        public String translate(String key) {
            return this.translate(this.locale, key);
        }

        public Map<String, String> translate(Locale locale, String ... keys) {
            LinkedHashMap<String, String> retmap = new LinkedHashMap<String, String>();
            for (String key : keys) {
                retmap.put(key, this.translate(locale, key));
            }
            return retmap;
        }

        public Map<String, String> translate(String ... keys) {
            return this.translate(this.locale, keys);
        }

        public String[] allPropertyKeys(Locale locale) {
            return Resource.resourceBasedTranslator.resolveAllKeys(this.baseName, locale);
        }

        public String[] allPropertyKeys() {
            return this.allPropertyKeys(this.locale);
        }

        public Map<String, String> translationMap() {
            return this.translate(this.allPropertyKeys());
        }

        public Map<String, String> translationMap(Locale locale) {
            return this.translate(locale, this.allPropertyKeys(locale));
        }
    }

    public static interface ResourceBasedTranslator {
        public String translate(String var1, String var2, Locale var3);

        public String[] resolveAllKeys(String var1, Locale var2);
    }

    public static class Resource {
        public static ResourceBasedTranslator resourceBasedTranslator = new ResourceBasedTranslator(){

            @Override
            public String translate(String baseName, String key, Locale locale) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
                return resourceBundle.getString(key);
            }

            @Override
            public String[] resolveAllKeys(String baseName, Locale locale) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
                return resourceBundle.keySet().toArray(new String[0]);
            }
        };
    }
}

