/*
 * Decompiled with CFR 0.152.
 */
package org.maven.i18nbinder.plugin;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.omnaest.i18nbinder.internal.LocaleFilter;
import org.omnaest.i18nbinder.internal.ModifierHelper;

public class I18nBinderCreatePropertiesFromXlsMojo
extends AbstractMojo {
    private File xlsOutputDirectory;
    private String localeFilterRegex = ".*";
    private String xlsFileName = "i18n.xls";
    private String propertyFileEncoding = "utf-8";
    private boolean deletePropertiesWithBlankValue = true;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Write properties from XLS file back to property files...");
        this.logConfigurationProperties();
        LocaleFilter localeFilter = this.determineLocaleFilter();
        try {
            if (this.xlsFileName != null) {
                File file = new File(this.xlsOutputDirectory, this.xlsFileName);
                this.getLog().info((CharSequence)("Looking for xls file at:" + file));
                if (file.exists()) {
                    ModifierHelper.writeXLSFileContentToPropertyFiles((File)file, (String)this.propertyFileEncoding, (LocaleFilter)localeFilter, (boolean)this.deletePropertiesWithBlankValue);
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Could not write properties from xls", (Throwable)e);
        }
        this.getLog().info((CharSequence)"...done");
    }

    private void logConfigurationProperties() {
        this.getLog().info((CharSequence)("localeFilterRegex=" + this.localeFilterRegex));
        this.getLog().info((CharSequence)("xlsOutputDirectory=" + this.xlsOutputDirectory));
        this.getLog().info((CharSequence)("xlsFileName=" + this.xlsFileName));
    }

    private LocaleFilter determineLocaleFilter() {
        LocaleFilter localeFilter = new LocaleFilter();
        localeFilter.setPattern(Pattern.compile(this.localeFilterRegex));
        return localeFilter;
    }
}

