/*
 * Decompiled with CFR 0.152.
 */
package org.maven.i18nbinder.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.omnaest.i18nbinder.internal.LocaleFilter;
import org.omnaest.i18nbinder.internal.ModifierHelper;
import org.omnaest.i18nbinder.internal.XLSFile;

public class I18nBinderCreateXlsFromPropertiesMojo
extends AbstractMojo {
    private File xlsOutputDirectory;
    private File propertiesRootDirectory = new File("src/main/resources/i18n");
    private String localeFilterRegex = ".*";
    private String fileNameLocaleGroupPattern = ".*?((_\\w{2,3}_\\w{2,3})|(_\\w{2,3})|())\\.properties";
    private List<Integer> fileNameLocaleGroupPatternGroupIndexList = Arrays.asList(2, 3, 4);
    private boolean logResolvedPropertyFileNames = false;
    private String xlsFileName = "i18n.xls";
    private String propertyFileEncoding = "utf-8";

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Create XLS file from property files...");
        this.logConfigurationProperties();
        LocaleFilter localeFilter = this.determineLocaleFilter();
        Set<File> propertyFileSet = this.resolveFilesFromDirectoryRoot(this.propertiesRootDirectory);
        try {
            if (this.xlsFileName != null && !propertyFileSet.isEmpty()) {
                XLSFile xlsFile = ModifierHelper.createXLSFileFromPropertyFiles(propertyFileSet, (String)this.propertyFileEncoding, (LocaleFilter)localeFilter, (String)this.fileNameLocaleGroupPattern, this.fileNameLocaleGroupPatternGroupIndexList);
                File file = new File(this.xlsOutputDirectory, this.xlsFileName);
                xlsFile.setFile(file);
                xlsFile.store();
            } else {
                this.getLog().error((CharSequence)"No xls file name specified. Please provide a file name for the xls file which should be created.");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Could not write xls file", (Throwable)e);
        }
        this.getLog().info((CharSequence)"...done");
    }

    private void logConfigurationProperties() {
        this.getLog().info((CharSequence)("fileNameLocaleGroupPattern=" + this.fileNameLocaleGroupPattern));
        this.getLog().info((CharSequence)("fileNameLocaleGroupPatternGroupIndexList=" + this.fileNameLocaleGroupPatternGroupIndexList));
        this.getLog().info((CharSequence)("localeFilterRegex=" + this.localeFilterRegex));
        this.getLog().info((CharSequence)("xlsOutputDirectory=" + this.xlsOutputDirectory));
        this.getLog().info((CharSequence)("xlsFileName=" + this.xlsFileName));
        this.getLog().info((CharSequence)("propertiesRootDirectory=" + this.propertiesRootDirectory));
    }

    private Set<File> resolveFilesFromDirectoryRoot(File propertiesRootDirectory) {
        LinkedHashSet<File> retset = new LinkedHashSet<File>();
        String[] includes = new String[]{"**/*.properties"};
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(includes);
        directoryScanner.setBasedir(propertiesRootDirectory);
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i].replaceAll("\\\\", "/");
            if (this.logResolvedPropertyFileNames) {
                this.getLog().info((CharSequence)("Resolved: " + fileName));
            }
            retset.add(new File(propertiesRootDirectory, fileName));
        }
        return retset;
    }

    private LocaleFilter determineLocaleFilter() {
        LocaleFilter localeFilter = new LocaleFilter();
        localeFilter.setPattern(Pattern.compile(this.localeFilterRegex));
        return localeFilter;
    }
}

