/*
 * Decompiled with CFR 0.152.
 */
package org.maven.i18nbinder.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.omnaest.i18nbinder.internal.FacadeCreatorHelper;
import org.omnaest.i18nbinder.internal.LocaleFilter;

public class I18nBinderMojo
extends AbstractMojo {
    private static final String GENERATED_SOURCES = "generated-sources";
    private static final String GENERATED_SOURCES_I18NBINDER = "i18nbinder";
    private File outputDirectory;
    private File propertiesRootDirectory = new File("src/main/resources/i18n");
    private String localeFilterRegex = ".*";
    private String fileNameLocaleGroupPattern = ".*?((_\\w{2,3}_\\w{2,3})|(_\\w{2,3})|())\\.properties";
    private List<Integer> fileNameLocaleGroupPatternGroupIndexList = Arrays.asList(2, 3, 4);
    private boolean createJavaFacade = true;
    private boolean logResolvedPropertyFileNames = false;
    private String i18nFacadeName = "I18nFacade";
    private String baseNameInTargetPlattform = "i18n";
    private String packageName = "";
    private boolean externalizeTypes = true;
    private MavenProject project;
    private String javaFileEncoding = "utf-8";
    private String propertyFileEncoding = "utf-8";

    public void execute() throws MojoExecutionException {
        if (!this.createJavaFacade) {
            this.getLog().info((CharSequence)"Skipping to create the i18n Java facade since it is disabled by the createJavaFacade property within the configuration");
        } else {
            this.getLog().info((CharSequence)"Create Java source code facade file from property files...");
            this.logConfigurationProperties();
            String baseFolderIgnoredPath = this.getBaseFolderIgnoredPath();
            LocaleFilter localeFilter = this.determineLocaleFilter();
            Set<File> propertyFileSet = this.resolveFilesFromDirectoryRoot(this.propertiesRootDirectory);
            try {
                String i18nFacadeName = StringUtils.defaultString((String)this.i18nFacadeName, (String)"I18nFacade");
                Map facadeFromPropertyFiles = FacadeCreatorHelper.createI18nInterfaceFacadeFromPropertyFiles(propertyFileSet, (LocaleFilter)localeFilter, (String)this.fileNameLocaleGroupPattern, this.fileNameLocaleGroupPatternGroupIndexList, (String)this.baseNameInTargetPlattform, (String)baseFolderIgnoredPath, (String)this.packageName, (String)i18nFacadeName, (boolean)this.externalizeTypes, (String)this.propertyFileEncoding);
                File generatedSourceDirectory = this.createGeneratedSourcesI18nBinderDirectory();
                File targetPackageDirectory = this.createTargetPackageDirectory(generatedSourceDirectory);
                for (String fileName : facadeFromPropertyFiles.keySet()) {
                    String fileContent = (String)facadeFromPropertyFiles.get(fileName);
                    if (fileName.contains(".")) {
                        fileName = this.reduceFileNameAndCreateDirectoryPath(fileName, targetPackageDirectory);
                    }
                    File file = new File(targetPackageDirectory, fileName + ".java");
                    this.writeContentToFile(fileContent, file, fileName);
                }
                this.project.addCompileSourceRoot(this.getCompileSourceRoots());
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Could not write Java facade to file", (Throwable)e);
            }
            this.getLog().info((CharSequence)"...done");
        }
    }

    private void writeContentToFile(String fileContent, File file, String fileName) throws IOException {
        if (this.logResolvedPropertyFileNames) {
            this.getLog().info((CharSequence)("Writes to: " + fileName));
        }
        FileUtils.writeStringToFile((File)file, (String)fileContent, (String)this.javaFileEncoding);
    }

    private String getBaseFolderIgnoredPath() {
        try {
            return this.propertiesRootDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            return this.propertiesRootDirectory.getAbsolutePath();
        }
    }

    private File createTargetPackageDirectory(File generatedSourceDirectory) {
        String[] pathTokens = StringUtils.split((String)this.packageName, (String)".");
        File currentDirectory = generatedSourceDirectory;
        for (String pathToken : pathTokens) {
            if ((currentDirectory = new File(currentDirectory, pathToken)).exists()) continue;
            currentDirectory.mkdir();
        }
        return new File(generatedSourceDirectory, this.packageName.replaceAll("\\.", "/"));
    }

    private void logConfigurationProperties() {
        this.getLog().info((CharSequence)("baseNameInTargetPlattform=" + this.baseNameInTargetPlattform));
        this.getLog().info((CharSequence)("createJavaFacade=" + this.createJavaFacade));
        this.getLog().info((CharSequence)("javaFileEncoding=" + this.javaFileEncoding));
        this.getLog().info((CharSequence)("externalizeTypes=" + this.externalizeTypes));
        this.getLog().info((CharSequence)("fileNameLocaleGroupPattern=" + this.fileNameLocaleGroupPattern));
        this.getLog().info((CharSequence)("fileNameLocaleGroupPatternGroupIndexList=" + this.fileNameLocaleGroupPatternGroupIndexList));
        this.getLog().info((CharSequence)("i18nFacadeName=" + this.i18nFacadeName));
        this.getLog().info((CharSequence)("localeFilterRegex=" + this.localeFilterRegex));
        this.getLog().info((CharSequence)("outputDirectory=" + this.outputDirectory));
        this.getLog().info((CharSequence)("packageName=" + this.packageName));
        this.getLog().info((CharSequence)("propertiesRootDirectory=" + this.propertiesRootDirectory));
    }

    private File createGeneratedSourcesI18nBinderDirectory() {
        File generatedSourcesDirectory = new File(this.outputDirectory, GENERATED_SOURCES);
        File generatedSourcesI18nBinderDirectory = new File(generatedSourcesDirectory, GENERATED_SOURCES_I18NBINDER);
        if (!generatedSourcesDirectory.exists()) {
            generatedSourcesDirectory.mkdir();
        }
        if (!generatedSourcesI18nBinderDirectory.exists()) {
            generatedSourcesI18nBinderDirectory.mkdir();
        }
        return generatedSourcesI18nBinderDirectory;
    }

    private Set<File> resolveFilesFromDirectoryRoot(File propertiesRootDirectory) {
        LinkedHashSet<File> retset = new LinkedHashSet<File>();
        String[] includes = new String[]{"**/*.properties"};
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(includes);
        directoryScanner.setBasedir(propertiesRootDirectory);
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i].replaceAll("\\\\", "/");
            if (this.logResolvedPropertyFileNames) {
                this.getLog().info((CharSequence)("Resolved: " + fileName));
            }
            retset.add(new File(propertiesRootDirectory, fileName));
        }
        return retset;
    }

    private LocaleFilter determineLocaleFilter() {
        LocaleFilter localeFilter = new LocaleFilter();
        localeFilter.setPattern(Pattern.compile(this.localeFilterRegex));
        return localeFilter;
    }

    private String reduceFileNameAndCreateDirectoryPath(String fileName, File targetPackageDirectory) {
        String reducedFileName;
        fileName = reducedFileName = StringUtils.removeStart((String)fileName, (String)(this.packageName + "."));
        File directory = targetPackageDirectory;
        String[] tokens = fileName.split("\\.");
        for (int ii = 0; ii < tokens.length - 1; ++ii) {
            String directoryName = tokens[ii];
            if ((directory = new File(directory, directoryName)).exists()) continue;
            directory.mkdir();
        }
        fileName = StringUtils.join((Object[])Arrays.copyOf(tokens, tokens.length - 1), (String)"/") + (tokens.length > 1 ? "/" : "") + tokens[tokens.length - 1];
        return reducedFileName.replaceAll("\\.", "/");
    }

    public String getCompileSourceRoots() throws IOException {
        return new File(this.outputDirectory, "generated-sources/i18nbinder").getCanonicalPath();
    }
}

