/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.component;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.oncoblocks.centromere.core.dataimport.component.DataImportException;
import org.oncoblocks.centromere.core.dataimport.component.RecordReader;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordFileReader<T extends Model<?>>
implements RecordReader<T> {
    private BufferedReader reader;
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordFileReader.class);

    @Override
    public void doBefore(String input) throws DataImportException {
        this.close();
        this.open(input);
    }

    @Override
    public void doAfter() {
        this.close();
    }

    public void open(String inputFilePath) throws DataImportException {
        File file = new File(inputFilePath);
        if (!file.canRead() || !file.isFile()) {
            try {
                file = new File(ClassLoader.getSystemClassLoader().getResource(inputFilePath).getPath());
            }
            catch (NullPointerException e) {
                throw new DataImportException(String.format("Cannot locate dataimport file: %s", inputFilePath));
            }
        }
        try {
            this.reader = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DataImportException(String.format("Cannot read dataimport file: %s", inputFilePath));
        }
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.debug(e.getMessage());
            }
        }
    }

    protected BufferedReader getReader() {
        return this.reader;
    }
}

