/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.component;

import java.io.File;
import org.oncoblocks.centromere.core.dataimport.component.DataImportException;
import org.oncoblocks.centromere.core.dataimport.component.RecordImporter;
import org.oncoblocks.centromere.core.dataimport.component.RecordProcessor;
import org.oncoblocks.centromere.core.dataimport.component.RecordReader;
import org.oncoblocks.centromere.core.dataimport.component.RecordWriter;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataSetAware;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportOptions;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportOptionsAware;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class GenericRecordProcessor<T extends Model<?>>
implements RecordProcessor,
ImportOptionsAware,
DataSetAware {
    private RecordReader<T> reader;
    private Validator validator;
    private RecordWriter<T> writer;
    private RecordImporter importer;
    private ImportOptions options;
    private Object dataSetId;
    private static final Logger logger = LoggerFactory.getLogger(GenericRecordProcessor.class);

    public GenericRecordProcessor() {
    }

    public GenericRecordProcessor(RecordReader<T> reader, Validator validator, RecordWriter<T> writer, RecordImporter importer, ImportOptions options) {
        this.reader = reader;
        this.validator = validator;
        this.writer = writer;
        this.importer = importer;
        this.options = options;
    }

    @Override
    public void doBefore() {
        this.checkImportOptions();
        if (this.writer != null && this.writer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.writer)).setImportOptions(this.options);
        }
        if (this.reader != null && this.reader instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.reader)).setImportOptions(this.options);
        }
        if (this.importer != null && this.importer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.importer)).setImportOptions(this.options);
        }
        if (this.writer != null && this.writer instanceof DataSetAware) {
            ((DataSetAware)((Object)this.writer)).setDataSetId(this.dataSetId);
        }
        if (this.reader != null && this.reader instanceof DataSetAware) {
            ((DataSetAware)((Object)this.reader)).setDataSetId(this.dataSetId);
        }
        if (this.importer != null && this.importer instanceof DataSetAware) {
            ((DataSetAware)((Object)this.importer)).setDataSetId(this.dataSetId);
        }
    }

    @Override
    public void doAfter() {
    }

    @Override
    public void run(String inputFilePath) throws DataImportException {
        this.reader.doBefore(inputFilePath);
        this.writer.doBefore(this.getTempFilePath(inputFilePath));
        T record = this.reader.readRecord();
        while (record != null) {
            if (record instanceof DataSetAware) {
                ((DataSetAware)record).setDataSetId(this.dataSetId);
            }
            if (this.validator != null) {
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(record, record.getClass().getName());
                this.validator.validate(record, (Errors)bindingResult);
                if (bindingResult.hasErrors()) {
                    logger.warn(String.format("Record failed validation: %s", record.toString()));
                    if (this.options.getBoolean("failOnInvalidRecord")) {
                        throw new DataImportException(bindingResult.toString());
                    }
                }
            }
            this.writer.writeRecord(record);
            record = this.reader.readRecord();
        }
        this.writer.doAfter();
        this.reader.doAfter();
        if (this.importer != null) {
            this.importer.importFile(this.getTempFilePath(inputFilePath));
        }
    }

    protected void checkImportOptions() {
        Assert.isTrue((boolean)this.options.hasOption("failOnInvalidRecord"), (String)"Missing required option: failOnInvalidRecord");
        Assert.isTrue((boolean)this.options.hasOption("tempDirectoryPath"), (String)"Missing required option: tempDirectoryPath");
    }

    private String getTempFilePath(String inputFilePath) {
        File tempDir = new File(this.options.getString("tempDirectoryPath"));
        String fileName = new File(inputFilePath).getName() + ".tmp";
        File tempFile = new File(tempDir, fileName);
        return tempFile.getPath();
    }

    public RecordReader<T> getReader() {
        return this.reader;
    }

    public void setReader(RecordReader<T> reader) {
        this.reader = reader;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public RecordWriter<T> getWriter() {
        return this.writer;
    }

    public void setWriter(RecordWriter<T> writer) {
        this.writer = writer;
    }

    public RecordImporter getImporter() {
        return this.importer;
    }

    public void setImporter(RecordImporter importer) {
        this.importer = importer;
    }

    public ImportOptions getImportOptions() {
        return this.options;
    }

    @Override
    public void setImportOptions(ImportOptions options) {
        this.options = options;
    }

    public Object getDataSetId() {
        return this.dataSetId;
    }

    @Override
    public void setDataSetId(Object dataSetId) {
        this.dataSetId = dataSetId;
    }
}

