/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.pipeline;

import java.util.HashMap;
import java.util.Map;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataSetMetadata;
import org.springframework.util.Assert;

public class DataSetManager {
    private final Map<String, DataSetMetadata> dataSetMap = new HashMap<String, DataSetMetadata>();

    public DataSetManager() {
    }

    public DataSetManager(Iterable<DataSetMetadata> dataSets) {
        this.addDataSets(dataSets);
    }

    public void addDataSet(DataSetMetadata dataSet) {
        Assert.notNull((Object)dataSet);
        Assert.notNull((Object)dataSet.getName());
        this.dataSetMap.put(dataSet.getName(), dataSet);
    }

    public void addDataSets(Iterable<DataSetMetadata> dataSets) {
        Assert.notNull(dataSets);
        for (DataSetMetadata dataSet : dataSets) {
            this.addDataSet(dataSet);
        }
    }

    public DataSetMetadata getDataSetByName(String name) {
        DataSetMetadata dataSet = null;
        if (this.dataSetMap.containsKey(name)) {
            dataSet = this.dataSetMap.get(name);
        }
        return dataSet;
    }
}

