/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.pipeline;

import java.util.HashMap;
import java.util.Map;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataType;
import org.springframework.util.Assert;

public class DataTypeManager {
    private final Map<String, DataType> dataTypeMap = new HashMap<String, DataType>();

    public DataTypeManager() {
    }

    public DataTypeManager(Iterable<DataType> dataTypes) {
        this.addDataTypes(dataTypes);
    }

    public DataTypeManager(DataType ... dataTypes) {
        for (DataType dataType : dataTypes) {
            this.addDataType(dataType);
        }
    }

    public void addDataType(DataType dataType) {
        Assert.notNull((Object)dataType);
        Assert.notNull((Object)dataType.getName());
        Assert.notNull((Object)dataType.getProcessor());
        Assert.notNull((Object)dataType.getOptions());
        this.dataTypeMap.put(dataType.getName(), dataType);
    }

    public void addDataTypes(Iterable<DataType> dataTypes) {
        for (DataType dataType : dataTypes) {
            this.addDataType(dataType);
        }
    }

    public String getProcessorByDataType(String name) {
        if (!this.dataTypeMap.containsKey(name)) {
            return null;
        }
        DataType dataType = this.dataTypeMap.get(name);
        return dataType.getProcessor();
    }

    public boolean isSupportedDataType(String name) {
        return this.dataTypeMap.containsKey(name);
    }
}

