/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.pipeline;

import java.util.HashMap;
import java.util.Map;
import org.oncoblocks.centromere.core.dataimport.component.DataImportException;
import org.oncoblocks.centromere.core.dataimport.component.DataTypes;
import org.oncoblocks.centromere.core.dataimport.component.RecordProcessor;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataSetAware;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataSetManager;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataSetMetadata;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataType;
import org.oncoblocks.centromere.core.dataimport.pipeline.DataTypeManager;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportJob;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportOptions;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportOptionsAware;
import org.oncoblocks.centromere.core.dataimport.pipeline.InputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class ImportJobRunner
implements ApplicationContextAware {
    private ImportJob importJob;
    private ApplicationContext applicationContext;
    private DataTypeManager dataTypeManager;
    private DataSetManager dataSetManager;
    private static final Logger logger = LoggerFactory.getLogger(ImportJobRunner.class);

    public ImportJobRunner() {
    }

    public ImportJobRunner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void runImport() throws DataImportException {
        this.configurationCheck();
        for (InputFile inputFile : this.importJob.getFiles()) {
            String dataSetName = inputFile.getDataSet();
            String dataTypeName = inputFile.getDataType();
            String inputFilePath = inputFile.getPath();
            DataSetMetadata dataSetMetadata = this.dataSetManager.getDataSetByName(dataSetName);
            ImportOptions combinedOptions = this.mergeImportOptions(inputFile.getOptions(), this.importJob.getOptions());
            this.processDataSet(dataSetMetadata, inputFile);
            RecordProcessor processor = this.getProcessorInstanceByDataType(dataTypeName);
            if (processor instanceof ImportOptionsAware && inputFile.getOptions() != null) {
                ((ImportOptionsAware)((Object)processor)).setImportOptions(combinedOptions);
            }
            if (processor instanceof DataSetAware) {
                Object dataSetId = this.getDataSetId(dataSetMetadata, inputFile);
                ((DataSetAware)((Object)processor)).setDataSetId(dataSetId);
            }
            logger.info(String.format("[CENTROMERE] Processing dataimport file: dataSet=%s dataType=%s, processor=%s, filePath=%s", dataSetName, dataTypeName, processor.getClass().getName(), inputFilePath));
            processor.doBefore();
            processor.run(inputFilePath);
            processor.doAfter();
            logger.info(String.format("[CENTROMERE] Completed file processing: %s", inputFilePath));
        }
    }

    protected ImportOptions mergeImportOptions(ImportOptions fileOptions, ImportOptions jobOptions) {
        HashMap<String, String> options = new HashMap<String, String>(jobOptions.getOptionsMap());
        options.putAll(new HashMap<String, String>(fileOptions.getOptionsMap()));
        return new ImportOptions(options);
    }

    protected void jobSetup() {
        this.configureDataTypeManager();
        this.configureDataSetManager();
    }

    protected void processDataSet(DataSetMetadata dataSet, InputFile inputFile) throws DataImportException {
    }

    protected Object getDataSetId(DataSetMetadata dataSet, InputFile inputFile) {
        return null;
    }

    protected void configurationCheck() throws DataImportException {
        if (this.dataTypeManager == null) {
            throw new DataImportException("DataTypeManager has not been configured.");
        }
    }

    protected void validateImportJob() throws DataImportException {
        try {
            Assert.notNull((Object)this.importJob, (String)"ImportJob must not be null");
            Assert.isTrue((this.importJob.getFiles() != null && !this.importJob.getFiles().isEmpty() ? 1 : 0) != 0, (String)"Import file list must not be empty.");
            Assert.isTrue((this.importJob.getDataSets() != null && !this.importJob.getDataSets().isEmpty() ? 1 : 0) != 0, (String)"Data set list must not be empty.");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
    }

    protected void configureDataTypeManager() {
        this.dataTypeManager = new DataTypeManager();
        for (Map.Entry entry : this.applicationContext.getBeansWithAnnotation(DataTypes.class).entrySet()) {
            Object obj = entry.getValue();
            if (!(obj instanceof RecordProcessor)) continue;
            RecordProcessor p = (RecordProcessor)obj;
            DataTypes dataTypes = p.getClass().getAnnotation(DataTypes.class);
            for (String t : dataTypes.value()) {
                this.dataTypeManager.addDataType(new DataType(t, p.getClass().getName()));
            }
        }
        if (this.importJob.getDataTypes() != null) {
            this.dataTypeManager.addDataTypes(this.importJob.getDataTypes());
        }
    }

    protected void configureDataSetManager() {
        this.dataSetManager = new DataSetManager();
        this.dataSetManager.addDataSets(this.importJob.getDataSets());
    }

    protected RecordProcessor getProcessorInstanceByDataType(String name) throws DataImportException {
        if (!this.dataTypeManager.isSupportedDataType(name)) {
            throw new DataImportException(String.format("Requested data type is not supported in the current configuration: %s", name));
        }
        RecordProcessor processor = null;
        String processorRef = this.dataTypeManager.getProcessorByDataType(name);
        try {
            Class<?> processorClass = Class.forName(processorRef);
            processor = (RecordProcessor)this.applicationContext.getBean(processorClass);
        }
        catch (ClassNotFoundException e) {
            processor = (RecordProcessor)this.applicationContext.getBean(processorRef);
        }
        if (processor == null) {
            throw new DataImportException(String.format("RecordProcessor bean does not exist: %s", processorRef));
        }
        return processor;
    }

    public ImportJob getImportJob() {
        return this.importJob;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    public DataSetManager getDataSetManager() {
        return this.dataSetManager;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setImportJob(ImportJob importJob) throws DataImportException {
        this.importJob = importJob;
        this.validateImportJob();
        this.jobSetup();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

