/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport.pipeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.oncoblocks.centromere.core.dataimport.component.DataImportException;
import org.oncoblocks.centromere.core.dataimport.pipeline.ImportJob;
import org.oncoblocks.centromere.core.dataimport.pipeline.JobFileParser;

public class JsonJobFileParser
implements JobFileParser {
    private ObjectMapper objectMapper;

    public JsonJobFileParser() {
        this.objectMapper = new ObjectMapper();
    }

    public JsonJobFileParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public ImportJob parseJobFile(String inputPath) throws DataImportException {
        ImportJob job = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(inputPath));
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        try {
            job = (ImportJob)this.objectMapper.readValue(builder.toString(), ImportJob.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
        return job;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

