/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport;

import java.io.FileWriter;
import java.io.IOException;
import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.dataimport.RecordWriter;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordFileWriter<T extends Model<?>>
implements RecordWriter<T> {
    private FileWriter writer;
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordFileWriter.class);

    @Override
    public void doBefore(String destination) throws DataImportException {
        this.open(destination);
    }

    @Override
    public void doAfter() throws DataImportException {
        this.close();
    }

    public void open(String outputFilePath) throws DataImportException {
        this.close();
        try {
            this.writer = new FileWriter(outputFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DataImportException(String.format("Cannot open output file: %s", outputFilePath));
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    protected FileWriter getWriter() {
        return this.writer;
    }
}

