/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport;

import java.io.File;
import org.oncoblocks.centromere.core.dataimport.BasicImportOptions;
import org.oncoblocks.centromere.core.dataimport.DataFileAware;
import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.dataimport.DataSetAware;
import org.oncoblocks.centromere.core.dataimport.ImportOptions;
import org.oncoblocks.centromere.core.dataimport.ImportOptionsAware;
import org.oncoblocks.centromere.core.dataimport.RecordImporter;
import org.oncoblocks.centromere.core.dataimport.RecordProcessor;
import org.oncoblocks.centromere.core.dataimport.RecordReader;
import org.oncoblocks.centromere.core.dataimport.RecordWriter;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.model.support.DataFileMetadata;
import org.oncoblocks.centromere.core.model.support.DataSetMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class GenericRecordProcessor<T extends Model<?>>
implements RecordProcessor<T>,
ImportOptionsAware,
DataSetAware,
DataFileAware {
    private Class<T> model;
    private RecordReader<T> reader;
    private Validator validator;
    private RecordWriter<T> writer;
    private RecordImporter importer;
    private BasicImportOptions options;
    private DataSetMetadata dataSet;
    private DataFileMetadata dataFile;
    private static final Logger logger = LoggerFactory.getLogger(GenericRecordProcessor.class);

    public GenericRecordProcessor() {
    }

    public GenericRecordProcessor(Class<T> model, RecordReader<T> reader, Validator validator, RecordWriter<T> writer) {
        this.model = model;
        this.reader = reader;
        this.validator = validator;
        this.writer = writer;
    }

    public GenericRecordProcessor(Class<T> model, RecordReader<T> reader, Validator validator, RecordWriter<T> writer, RecordImporter importer) {
        this.model = model;
        this.reader = reader;
        this.validator = validator;
        this.writer = writer;
        this.importer = importer;
    }

    public GenericRecordProcessor(Class<T> model, RecordReader<T> reader, Validator validator, RecordWriter<T> writer, RecordImporter importer, BasicImportOptions options) {
        this.model = model;
        this.reader = reader;
        this.validator = validator;
        this.writer = writer;
        this.importer = importer;
        this.options = options;
    }

    @Override
    public void doBefore() {
        this.configureComponents();
    }

    protected void configureComponents() {
        if (this.writer != null && this.writer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.writer)).setImportOptions(this.options);
        }
        if (this.reader != null && this.reader instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.reader)).setImportOptions(this.options);
        }
        if (this.importer != null && this.importer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.importer)).setImportOptions(this.options);
        }
        if (this.writer != null && this.writer instanceof DataSetAware) {
            ((DataSetAware)((Object)this.writer)).setDataSetMetadata(this.dataSet);
        }
        if (this.reader != null && this.reader instanceof DataSetAware) {
            ((DataSetAware)((Object)this.reader)).setDataSetMetadata(this.dataSet);
        }
        if (this.importer != null && this.importer instanceof DataSetAware) {
            ((DataSetAware)((Object)this.importer)).setDataSetMetadata(this.dataSet);
        }
        if (this.writer != null && this.writer instanceof DataFileAware) {
            ((DataFileAware)((Object)this.writer)).setDataFileMetadata(this.dataFile);
        }
        if (this.reader != null && this.reader instanceof DataFileAware) {
            ((DataFileAware)((Object)this.reader)).setDataFileMetadata(this.dataFile);
        }
        if (this.importer != null && this.importer instanceof DataFileAware) {
            ((DataFileAware)((Object)this.importer)).setDataFileMetadata(this.dataFile);
        }
    }

    @Override
    public void doAfter() {
    }

    @Override
    public void run(String inputFilePath) throws DataImportException {
        this.reader.doBefore(inputFilePath);
        this.writer.doBefore(this.getTempFilePath(inputFilePath));
        T record = this.reader.readRecord();
        while (record != null) {
            if (record instanceof DataSetAware) {
                ((DataSetAware)record).setDataSetMetadata(this.dataSet);
            }
            if (this.validator != null) {
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(record, record.getClass().getName());
                this.validator.validate(record, (Errors)bindingResult);
                if (bindingResult.hasErrors()) {
                    logger.warn(String.format("Record failed validation: %s", record.toString()));
                    if (!this.options.isSkipInvalidRecords()) {
                        throw new DataImportException(bindingResult.toString());
                    }
                }
            }
            this.writer.writeRecord(record);
            record = this.reader.readRecord();
        }
        this.writer.doAfter();
        this.reader.doAfter();
        if (this.importer != null) {
            this.importer.importFile(this.getTempFilePath(inputFilePath));
        }
    }

    private String getTempFilePath(String inputFilePath) {
        File tempDir = new File(this.options.getTempDirectoryPath());
        String fileName = new File(inputFilePath).getName() + ".tmp";
        File tempFile = new File(tempDir, fileName);
        return tempFile.getPath();
    }

    @Override
    public Class<T> getModel() {
        return this.model;
    }

    @Override
    public void setModel(Class<T> model) {
        this.model = model;
    }

    @Override
    public RecordReader<T> getReader() {
        return this.reader;
    }

    @Override
    public void setReader(RecordReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public RecordWriter<T> getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(RecordWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public RecordImporter getImporter() {
        return this.importer;
    }

    @Override
    public void setImporter(RecordImporter importer) {
        this.importer = importer;
    }

    public ImportOptions getImportOptions() {
        return this.options;
    }

    @Override
    public void setImportOptions(ImportOptions options) {
        this.options = new BasicImportOptions(options);
    }

    public void setImportOptions(BasicImportOptions options) {
        this.options = options;
    }

    public DataSetMetadata getDataSet() {
        return this.dataSet;
    }

    @Override
    public void setDataSetMetadata(DataSetMetadata dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public void setDataFileMetadata(DataFileMetadata dataFileMetadata) {
        this.dataFile = dataFileMetadata;
    }

    public DataFileMetadata getDataFile() {
        return this.dataFile;
    }
}

