/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport;

import java.util.HashMap;
import java.util.Map;
import org.oncoblocks.centromere.core.dataimport.ImportOptions;

public class BasicImportOptions
implements ImportOptions {
    private Map<String, String> options = new HashMap<String, String>();
    private boolean skipInvalidSamples = false;
    private boolean skipInvalidDataSets = false;
    private boolean skipInvalidGenes = false;
    private boolean skipInvalidMetadata = false;
    private boolean skipInvalidRecords = false;
    private boolean skipExistingFiles = false;
    private String tempDirectoryPath = "/tmp";

    public BasicImportOptions() {
    }

    public BasicImportOptions(Map<String, String> options) {
        this.options = options;
        this.setDefaultParameters();
    }

    public BasicImportOptions(ImportOptions importOptions) {
        this(importOptions.getOptions());
    }

    private void setDefaultParameters() {
        if (this.options.containsKey("skipInvalidSamples")) {
            this.skipInvalidSamples = Boolean.parseBoolean(this.options.get("skipInvalidSamples"));
        }
        if (this.options.containsKey("skipInvalidDataSets")) {
            this.skipInvalidDataSets = Boolean.parseBoolean(this.options.get("skipInvalidDataSets"));
        }
        if (this.options.containsKey("skipInvalidGenes")) {
            this.skipInvalidGenes = Boolean.parseBoolean(this.options.get("skipInvalidGenes"));
        }
        if (this.options.containsKey("skipInvalidMetadata")) {
            this.skipInvalidMetadata = Boolean.parseBoolean(this.options.get("skipInvalidMetadata"));
        }
        if (this.options.containsKey("skipInvalidRecords")) {
            this.skipInvalidRecords = Boolean.parseBoolean(this.options.get("skipInvalidRecords"));
        }
        if (this.options.containsKey("skipExistingFiles")) {
            this.skipExistingFiles = Boolean.parseBoolean(this.options.get("skipExistingFiles"));
        }
        if (this.options.containsKey("tempDirectoryPath")) {
            this.tempDirectoryPath = this.options.get("tempDirectoryPath");
        }
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public String getOption(String name) {
        return this.options.containsKey(name) ? this.options.get(name) : null;
    }

    public boolean getBoolean(String name) {
        if (!this.options.containsKey(name)) {
            throw new NullPointerException("Invalid option: " + name);
        }
        return Boolean.parseBoolean(this.options.get(name));
    }

    public void setOption(String name, String value) {
        this.options.put(name, value);
        this.setDefaultParameters();
    }

    public void setOptions(Map<String, String> options) {
        this.options.putAll(options);
        this.setDefaultParameters();
    }

    @Override
    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public boolean isSkipInvalidSamples() {
        return this.skipInvalidSamples;
    }

    public boolean isSkipInvalidDataSets() {
        return this.skipInvalidDataSets;
    }

    public boolean isSkipInvalidGenes() {
        return this.skipInvalidGenes;
    }

    public boolean isSkipInvalidMetadata() {
        return this.skipInvalidMetadata;
    }

    public boolean isSkipInvalidRecords() {
        return this.skipInvalidRecords;
    }

    public void setSkipInvalidSamples(boolean skipInvalidSamples) {
        this.skipInvalidSamples = skipInvalidSamples;
        this.options.put("skipInvalidSamples", Boolean.toString(skipInvalidSamples));
    }

    public void setSkipInvalidDataSets(boolean skipInvalidDataSets) {
        this.skipInvalidDataSets = skipInvalidDataSets;
        this.options.put("skipInvalidDataSets", Boolean.toString(skipInvalidDataSets));
    }

    public void setSkipInvalidGenes(boolean skipInvalidGenes) {
        this.skipInvalidGenes = skipInvalidGenes;
        this.options.put("skipInvalidGenes", Boolean.toString(skipInvalidGenes));
    }

    public void setSkipInvalidMetadata(boolean skipInvalidMetadata) {
        this.skipInvalidMetadata = skipInvalidMetadata;
        this.options.put("skipInvalidMetadata", Boolean.toString(skipInvalidMetadata));
    }

    public void setSkipInvalidRecords(boolean skipInvalidRecords) {
        this.skipInvalidRecords = skipInvalidRecords;
        this.options.put("skipInvalidRecords", Boolean.toString(skipInvalidRecords));
    }

    public void setTempDirectoryPath(String tempDirectoryPath) {
        this.tempDirectoryPath = tempDirectoryPath;
        this.options.put("tempDirectoryPath", tempDirectoryPath);
    }

    public boolean isSkipExistingFiles() {
        return this.skipExistingFiles;
    }

    public void setSkipExistingFiles(boolean skipExistingFiles) {
        this.skipExistingFiles = skipExistingFiles;
        this.options.put("skipExistingFiles", Boolean.toString(skipExistingFiles));
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    public String toString() {
        return "BasicImportOptions{options=" + this.options + ", skipInvalidSamples=" + this.skipInvalidSamples + ", skipInvalidDataSets=" + this.skipInvalidDataSets + ", skipInvalidGenes=" + this.skipInvalidGenes + ", skipInvalidMetadata=" + this.skipInvalidMetadata + ", skipInvalidRecords=" + this.skipInvalidRecords + ", skipExistingFiles=" + this.skipExistingFiles + ", tempDirectoryPath='" + this.tempDirectoryPath + '\'' + '}';
    }
}

