/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.oncoblocks.centromere.core.dataimport.DataTypeSupport;
import org.oncoblocks.centromere.core.dataimport.DataTypes;
import org.oncoblocks.centromere.core.dataimport.RecordProcessor;
import org.oncoblocks.centromere.core.util.AbstractComponentRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class DataTypeProcessorRegistry
extends AbstractComponentRegistry<RecordProcessor>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(DataTypeProcessorRegistry.class);

    public DataTypeProcessorRegistry() {
    }

    public DataTypeProcessorRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void configure() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must not be null.");
        for (Map.Entry entry : this.applicationContext.getBeansOfType(RecordProcessor.class).entrySet()) {
            this.add((RecordProcessor)entry.getValue());
        }
    }

    @Override
    public void add(RecordProcessor processor) {
        if (processor instanceof DataTypeSupport) {
            for (String dataType : ((DataTypeSupport)((Object)processor)).getSupportedDataTypes()) {
                this.add(dataType, processor);
            }
        } else if (processor.getClass().isAnnotationPresent(DataTypes.class)) {
            DataTypes dataTypes = processor.getClass().getAnnotation(DataTypes.class);
            for (String dataType : dataTypes.value()) {
                this.add(dataType, processor);
            }
        } else {
            logger.warn(String.format("RecordProcessor does not have DataTypes annotation.  No data type mapping will be registered: %s", processor.getClass().getName()));
        }
    }

    @Override
    public void add(Class<? extends RecordProcessor> type) {
        Map map = this.applicationContext.getBeansOfType(type);
        for (Map.Entry entry : map.entrySet()) {
            this.add((RecordProcessor)entry.getValue());
        }
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

