/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class JsonModelConverter
implements Converter<String, Object> {
    private final ObjectMapper mapper;
    private final Class<? extends Model> model;
    private static final Logger logger = LoggerFactory.getLogger(JsonModelConverter.class);

    public JsonModelConverter(Class<? extends Model> model) {
        this.mapper = new ObjectMapper();
        this.model = model;
    }

    public JsonModelConverter(ObjectMapper mapper, Class<? extends Model> model) {
        this.mapper = mapper;
        this.model = model;
    }

    public Object convert(String s) {
        try {
            return this.mapper.readValue(s, this.model);
        }
        catch (IOException e) {
            logger.warn(String.format("[CENTROMERE] Unable to convert JSON to %s model object: %s", this.model.getName(), s));
            e.printStackTrace();
            return null;
        }
    }
}

