/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import java.util.HashSet;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.util.AbstractComponentRegistry;
import org.oncoblocks.centromere.core.util.ModelScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ModelRegistry
extends AbstractComponentRegistry<Class<? extends Model>> {
    private static final Logger logger = LoggerFactory.getLogger(ModelRegistry.class);

    public void addClasspathModels(String classpath) {
        logger.debug("Scanning classpath for Model classes: " + classpath);
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Model.class));
        for (BeanDefinition beanDef : provider.findCandidateComponents(classpath)) {
            try {
                Class<?> clazz = Class.forName(beanDef.getBeanClassName());
                if (!Model.class.isAssignableFrom(clazz)) continue;
                this.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                logger.warn(String.format("Cannot find target class: %s", beanDef.getBeanClassName()));
            }
        }
    }

    @Override
    public void add(Class<? extends Model> model) {
        logger.debug("Adding Model class to registry: " + model.getName());
        this.add(model.getSimpleName(), model);
    }

    @Override
    public Iterable<Class<? extends Model>> getRegisteredComponents() {
        HashSet<Class<? extends Model>> models = new HashSet<Class<? extends Model>>();
        for (Class model : this.getRegistry().values()) {
            models.add(model);
        }
        return models;
    }

    public static ModelRegistry fromModelScan(ModelScan modelScan) throws ClassNotFoundException {
        ModelRegistry registry = new ModelRegistry();
        if (modelScan.value().length > 0) {
            for (String string : modelScan.value()) {
                registry.addClasspathModels(string);
            }
        } else if (modelScan.basePackages().length > 0) {
            for (String string : modelScan.basePackages()) {
                registry.addClasspathModels(string);
            }
        }
        if (modelScan.basePackageClasses().length > 0) {
            for (Class<?> clazz : modelScan.basePackageClasses()) {
                if (Model.class.isAssignableFrom(clazz)) {
                    registry.add((Class<? extends Model>)clazz);
                    continue;
                }
                logger.warn(String.format("Cannot register non-model class: %s", clazz.getName()));
            }
        }
        return registry;
    }
}

