/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;
import org.oncoblocks.centromere.core.util.AbstractComponentRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class ModelRepositoryRegistry
extends AbstractComponentRegistry<RepositoryOperations>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(ModelRepositoryRegistry.class);
    private Map<Class<?>, Set<RepositoryOperations>> repositoryClassMap = new HashMap();

    public ModelRepositoryRegistry() {
    }

    public ModelRepositoryRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void configure() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must not be null.");
        for (Map.Entry entry : this.applicationContext.getBeansOfType(RepositoryOperations.class).entrySet()) {
            this.add((String)entry.getKey(), (RepositoryOperations)entry.getValue());
        }
    }

    @Override
    public void add(RepositoryOperations repository) {
        this.add(repository.getClass());
    }

    private void addRepositoryClassMapping(RepositoryOperations repository) {
        Set<RepositoryOperations> set = new HashSet<RepositoryOperations>();
        if (this.repositoryClassMap.containsKey(repository.getModel())) {
            set = this.repositoryClassMap.get(repository.getModel());
        }
        set.add(repository);
        this.repositoryClassMap.put(repository.getModel(), set);
    }

    @Override
    public void add(String name, RepositoryOperations repository) {
        super.add(name, repository);
        this.addRepositoryClassMapping(repository);
    }

    @Override
    public void add(Class<? extends RepositoryOperations> type) {
        Map map = this.applicationContext.getBeansOfType(type);
        for (Map.Entry entry : map.entrySet()) {
            this.add((String)entry.getKey(), (RepositoryOperations)entry.getValue());
        }
    }

    public List<RepositoryOperations> findByModel(Class<? extends Model> type) {
        if (this.repositoryClassMap.containsKey(type)) {
            return new ArrayList<RepositoryOperations>((Collection)this.repositoryClassMap.get(type));
        }
        return new ArrayList<RepositoryOperations>();
    }

    @Override
    public boolean exists(Class<? extends Model> type) {
        return this.repositoryClassMap.containsKey(type);
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

