/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport;

import com.google.common.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.oncoblocks.centromere.core.dataimport.BasicImportOptions;
import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.dataimport.DataTypeSupport;
import org.oncoblocks.centromere.core.dataimport.DataTypes;
import org.oncoblocks.centromere.core.dataimport.ImportOptions;
import org.oncoblocks.centromere.core.dataimport.ImportOptionsAware;
import org.oncoblocks.centromere.core.dataimport.RecordImporter;
import org.oncoblocks.centromere.core.dataimport.RecordProcessor;
import org.oncoblocks.centromere.core.dataimport.RecordReader;
import org.oncoblocks.centromere.core.dataimport.RecordWriter;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Validator;

public class GenericRecordProcessor<T extends Model<?>>
implements RecordProcessor<T>,
ImportOptionsAware,
DataTypeSupport {
    private Class<T> model = new TypeToken<T>(this.getClass()){}.getRawType();
    private RecordReader<T> reader;
    private Validator validator;
    private RecordWriter<T> writer;
    private RecordImporter importer;
    private BasicImportOptions options = new BasicImportOptions();
    private List<String> supportedDataTypes = new ArrayList<String>();
    private boolean isConfigured = false;
    private static final Logger logger = LoggerFactory.getLogger(GenericRecordProcessor.class);

    @Override
    public void doBefore(Object ... args) throws DataImportException {
    }

    @PostConstruct
    public void configure() {
        DataTypes dataTypes;
        if (this.getClass().isAnnotationPresent(DataTypes.class) && (dataTypes = this.getClass().getAnnotation(DataTypes.class)).value() != null && dataTypes.value().length > 0) {
            this.supportedDataTypes = Arrays.asList(dataTypes.value());
        }
        this.isConfigured = true;
    }

    @Override
    public void configureComponents() {
        if (this.writer != null && this.writer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.writer)).setImportOptions(this.options);
        }
        if (this.reader != null && this.reader instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.reader)).setImportOptions(this.options);
        }
        if (this.importer != null && this.importer instanceof ImportOptionsAware) {
            ((ImportOptionsAware)((Object)this.importer)).setImportOptions(this.options);
        }
    }

    @Override
    public void doAfter(Object ... args) throws DataImportException {
    }

    @Override
    public void run(Object ... args) throws DataImportException {
        if (!this.isConfigured) {
            logger.warn("Processor configuration method has not run!");
        }
        try {
            Assert.notEmpty((Object[])args, (String)"One or more arguments required.");
            Assert.isTrue((boolean)(args[0] instanceof String), (String)"The first argument must be a String.");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
        String inputFilePath = (String)args[0];
        this.reader.doBefore(inputFilePath);
        this.writer.doBefore(this.getTempFilePath(inputFilePath));
        T record = this.reader.readRecord();
        while (record != null) {
            if (this.validator != null) {
                DataBinder dataBinder = new DataBinder(record);
                dataBinder.setValidator(this.validator);
                dataBinder.validate();
                BindingResult bindingResult = dataBinder.getBindingResult();
                if (bindingResult.hasErrors()) {
                    logger.warn(String.format("Record failed validation: %s", record.toString()));
                    if (!this.options.isSkipInvalidRecords()) {
                        throw new DataImportException(bindingResult.toString());
                    }
                }
            }
            this.writer.writeRecord(record);
            record = this.reader.readRecord();
        }
        this.writer.doAfter(new Object[0]);
        this.reader.doAfter(new Object[0]);
        if (this.importer != null) {
            this.importer.importFile(this.getTempFilePath(inputFilePath));
        }
    }

    private String getTempFilePath(String inputFilePath) {
        File tempDir = new File(this.options.getTempDirectoryPath());
        String fileName = new File(inputFilePath).getName() + ".tmp";
        File tempFile = new File(tempDir, fileName);
        return tempFile.getPath();
    }

    @Override
    public boolean isSupportedDataType(String dataType) {
        return this.supportedDataTypes.contains(dataType);
    }

    @Override
    public void setSupportedDataTypes(Iterable<String> dataTypes) {
        ArrayList<String> types = new ArrayList<String>();
        for (String type : dataTypes) {
            types.add(type);
        }
        this.supportedDataTypes = types;
    }

    public List<String> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @Override
    public Class<T> getModel() {
        return this.model;
    }

    public void setModel(Class<T> model) {
        this.model = model;
    }

    @Override
    public RecordReader<T> getReader() {
        return this.reader;
    }

    @Override
    public void setReader(RecordReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public RecordWriter<T> getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(RecordWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public RecordImporter getImporter() {
        return this.importer;
    }

    @Override
    public void setImporter(RecordImporter importer) {
        this.importer = importer;
    }

    public ImportOptions getImportOptions() {
        return this.options;
    }

    @Override
    public void setImportOptions(ImportOptions options) {
        this.options = new BasicImportOptions(options);
    }

    public void setImportOptions(BasicImportOptions options) {
        this.options = options;
    }
}

