/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.dataimport;

import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.dataimport.RecordWriter;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;

public class RepositoryRecordWriter<T extends Model<?>>
implements RecordWriter<T> {
    private final RepositoryOperations<T, ?> repository;
    private WriteMode writeMode = WriteMode.INSERT;

    public RepositoryRecordWriter(RepositoryOperations<T, ?> repository) {
        this.repository = repository;
    }

    public RepositoryRecordWriter(RepositoryOperations<T, ?> repository, WriteMode writeMode) {
        this.repository = repository;
        this.writeMode = writeMode;
    }

    @Override
    public void writeRecord(T entity) throws DataImportException {
        if (this.writeMode.equals((Object)WriteMode.INSERT)) {
            this.repository.insert(entity);
        } else if (this.writeMode.equals((Object)WriteMode.UPDATE)) {
            this.repository.update(entity);
        } else if (this.writeMode.equals((Object)WriteMode.UPSERT)) {
            this.repository.save(entity);
        } else {
            throw new DataImportException("Invalid write mode selected: " + this.writeMode.toString());
        }
    }

    public RepositoryOperations<T, ?> getRepository() {
        return this.repository;
    }

    @Override
    public void doBefore(Object ... args) throws DataImportException {
    }

    @Override
    public void doAfter(Object ... args) throws DataImportException {
    }

    public static enum WriteMode {
        INSERT,
        UPDATE,
        UPSERT;

    }
}

