/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.oncoblocks.centromere.core.repository.Evaluation;
import org.oncoblocks.centromere.core.repository.QueryCriteria;

public class QueryCriteriaBuilder {
    private String field;
    private List<QueryCriteria> criterias = new ArrayList<QueryCriteria>();

    public QueryCriteriaBuilder(String field) {
        this.field = field;
    }

    public QueryCriteriaBuilder() {
    }

    public List<QueryCriteria> build() {
        return this.criterias;
    }

    public static QueryCriteriaBuilder where(String field) {
        return new QueryCriteriaBuilder(field);
    }

    public QueryCriteriaBuilder and(String field) {
        this.field = field;
        return this;
    }

    public QueryCriteriaBuilder is(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.EQUALS));
        return this;
    }

    public QueryCriteriaBuilder in(Collection<Object> values) {
        this.criterias.add(new QueryCriteria(this.field, values, Evaluation.IN));
        return this;
    }

    public QueryCriteriaBuilder isNot(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.NOT_EQUALS));
        return this;
    }

    public QueryCriteriaBuilder notIn(Collection<Object> values) {
        this.criterias.add(new QueryCriteria(this.field, values, Evaluation.NOT_IN));
        return this;
    }

    public QueryCriteriaBuilder like(String value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.LIKE));
        return this;
    }

    public QueryCriteriaBuilder notLike(String value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.NOT_LIKE));
        return this;
    }

    public QueryCriteriaBuilder greaterThan(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.GREATER_THAN));
        return this;
    }

    public QueryCriteriaBuilder greaterThanOrEqual(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.GREATER_THAN_EQUALS));
        return this;
    }

    public QueryCriteriaBuilder lessThan(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.LESS_THAN));
        return this;
    }

    public QueryCriteriaBuilder lessThanOrEqual(Object value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.LESS_THAN_EQUALS));
        return this;
    }

    public QueryCriteriaBuilder between(Object lowValue, Object highValue) {
        this.criterias.add(new QueryCriteria(this.field, Arrays.asList(lowValue, highValue), Evaluation.BETWEEN));
        return this;
    }

    public QueryCriteriaBuilder betweenIncluding(Object lowValue, Object highValue) {
        this.criterias.add(new QueryCriteria(this.field, Arrays.asList(lowValue, highValue), Evaluation.BETWEEN_INCLUSIVE));
        return this;
    }

    public QueryCriteriaBuilder outside(Object lowValue, Object highValue) {
        this.criterias.add(new QueryCriteria(this.field, Arrays.asList(lowValue, highValue), Evaluation.OUTSIDE));
        return this;
    }

    public QueryCriteriaBuilder outsideIncluding(Object lowValue, Object highValue) {
        this.criterias.add(new QueryCriteria(this.field, Arrays.asList(lowValue, highValue), Evaluation.OUTSIDE_INCLUSIVE));
        return this;
    }

    public QueryCriteriaBuilder isNull(Boolean value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.IS_NULL));
        return this;
    }

    public QueryCriteriaBuilder notNull(Boolean value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.NOT_NULL));
        return this;
    }

    public QueryCriteriaBuilder isTrue(Boolean value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.IS_TRUE));
        return this;
    }

    public QueryCriteriaBuilder isFalse(Boolean value) {
        this.criterias.add(new QueryCriteria(this.field, value, Evaluation.IS_FALSE));
        return this;
    }
}

