/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.oncoblocks.centromere.core.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class KeyValueMapModelConverter
implements Converter<Map<String, String>, Object> {
    private final Class<? extends Model> model;
    private final ObjectMapper mapper;
    private static final Logger logger = LoggerFactory.getLogger(KeyValueMapModelConverter.class);

    public KeyValueMapModelConverter(Class<? extends Model> model) {
        this.model = model;
        this.mapper = new ObjectMapper();
    }

    public KeyValueMapModelConverter(ObjectMapper mapper, Class<? extends Model> model) {
        this.model = model;
        this.mapper = mapper;
    }

    public Object convert(Map<String, String> map) {
        try {
            String json = this.mapper.writeValueAsString(map);
            return this.mapper.readValue(json, this.model);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn(String.format("[CENTROMERE] Unable to convert map to %s model object: %s", this.model.getName(), map.toString()));
            return null;
        }
    }
}

