/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oncoblocks.centromere.core.model.Alias;
import org.oncoblocks.centromere.core.model.Aliases;
import org.oncoblocks.centromere.core.model.ForeignKey;
import org.oncoblocks.centromere.core.model.Ignored;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.Evaluation;
import org.oncoblocks.centromere.core.repository.QueryParameterDescriptor;
import org.oncoblocks.centromere.core.repository.QueryParameterException;

public class QueryParameterUtil {
    public static QueryParameterDescriptor getDescriptorFromAlias(Alias alias, Field field) {
        QueryParameterDescriptor descriptor = new QueryParameterDescriptor();
        String fieldName = null;
        if (!alias.fieldName().equals("")) {
            fieldName = alias.fieldName();
        } else if (field != null) {
            fieldName = field.getName();
        } else {
            throw new QueryParameterException(String.format("No applicable parameter field name declared for alias: %s", alias.toString()));
        }
        descriptor.setParamName(alias.value());
        descriptor.setFieldName(fieldName);
        descriptor.setType(alias.type() == Object.class ? QueryParameterUtil.getQueryableFieldType(field) : alias.type());
        descriptor.setEvaluation(alias.evaluation());
        return descriptor;
    }

    public static List<QueryParameterDescriptor> getDescriptorsFromAliases(Aliases aliases, Field field) {
        ArrayList<QueryParameterDescriptor> descriptors = new ArrayList<QueryParameterDescriptor>();
        for (Alias alias : aliases.value()) {
            QueryParameterDescriptor descriptor = QueryParameterUtil.getDescriptorFromAlias(alias, field);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static List<QueryParameterDescriptor> getDescriptorsFromAliases(Aliases aliases) {
        return QueryParameterUtil.getDescriptorsFromAliases(aliases, null);
    }

    public static Map<String, QueryParameterDescriptor> getForeignKeyModelParameters(Class<? extends Model<?>> model) {
        HashMap<String, QueryParameterDescriptor> map = new HashMap<String, QueryParameterDescriptor>();
        for (Field field : model.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ForeignKey.class)) continue;
            ForeignKey foreignKey = field.getAnnotation(ForeignKey.class);
            String relField = !"".equals(foreignKey.rel()) ? foreignKey.rel() : field.getName();
            Map<String, QueryParameterDescriptor> foreignModelMap = QueryParameterUtil.getModelQueryParameters(foreignKey.model());
            for (QueryParameterDescriptor descriptor : foreignModelMap.values()) {
                String newParamName = relField + "." + descriptor.getParamName();
                descriptor.setParamName(newParamName);
                map.put(newParamName, descriptor);
            }
        }
        return map;
    }

    public static List<QueryParameterDescriptor> getFieldDescriptors(Field field) {
        ArrayList<QueryParameterDescriptor> descriptors = new ArrayList<QueryParameterDescriptor>();
        if (field.isSynthetic()) {
            return descriptors;
        }
        if (!field.isAnnotationPresent(Ignored.class)) {
            descriptors.add(new QueryParameterDescriptor(field.getName(), field.getName(), QueryParameterUtil.getQueryableFieldType(field), Evaluation.EQUALS));
        }
        if (field.isAnnotationPresent(Aliases.class)) {
            descriptors.addAll(QueryParameterUtil.getDescriptorsFromAliases(field.getAnnotation(Aliases.class), field));
        } else if (field.isAnnotationPresent(Alias.class)) {
            descriptors.add(QueryParameterUtil.getDescriptorFromAlias(field.getAnnotation(Alias.class), field));
        }
        return descriptors;
    }

    public static Class<?> getQueryableFieldType(Field field) {
        Class type = field.getType();
        if (Collection.class.isAssignableFrom(field.getType())) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            type = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Map<String, QueryParameterDescriptor> getModelQueryParameters(Class<? extends Model<?>> model) {
        HashMap<String, QueryParameterDescriptor> paramMap = new HashMap<String, QueryParameterDescriptor>();
        if (model.getClass().isAnnotationPresent(Aliases.class)) {
            for (QueryParameterDescriptor descriptor : QueryParameterUtil.getDescriptorsFromAliases(model.getClass().getAnnotation(Aliases.class))) {
                paramMap.put(descriptor.getParamName(), descriptor);
            }
        }
        for (Field field : model.getDeclaredFields()) {
            for (QueryParameterDescriptor descriptor : QueryParameterUtil.getFieldDescriptors(field)) {
                paramMap.put(descriptor.getParamName(), descriptor);
            }
        }
        return paramMap;
    }

    public static Map<String, QueryParameterDescriptor> getAvailableQueryParameters(Class<? extends Model<?>> model, boolean useForeignKeyParams) {
        HashMap<String, QueryParameterDescriptor> descriptorMap = new HashMap<String, QueryParameterDescriptor>();
        if (useForeignKeyParams) {
            descriptorMap.putAll(QueryParameterUtil.getForeignKeyModelParameters(model));
        }
        descriptorMap.putAll(QueryParameterUtil.getModelQueryParameters(model));
        return descriptorMap;
    }

    public static Map<String, QueryParameterDescriptor> getAvailableQueryParameters(Class<? extends Model<?>> model) {
        return QueryParameterUtil.getAvailableQueryParameters(model, false);
    }
}

