/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.sql;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.dataimport.DatabaseCredentials;
import org.oncoblocks.centromere.core.dataimport.RecordImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlImportTempFileImporter
implements RecordImporter {
    private DatabaseCredentials credentials;
    private boolean stopOnError = true;
    private boolean dropCollection = false;
    private String columns;
    private static final Logger logger = LoggerFactory.getLogger(MySqlImportTempFileImporter.class);

    public MySqlImportTempFileImporter(DatabaseCredentials credentials, String columns) {
        this.credentials = credentials;
        this.columns = columns;
    }

    public MySqlImportTempFileImporter(DatabaseCredentials credentials) {
        this(credentials, null);
    }

    public void importFile(String filePath) throws DataImportException {
        StringBuilder sb = new StringBuilder("mysqlimport --local ");
        if (!this.stopOnError) {
            sb.append(" --force ");
        }
        if (this.dropCollection) {
            sb.append(" --delete ");
        }
        if (this.columns != null) {
            sb.append(String.format(" -c %s ", this.columns));
        }
        sb.append(String.format(" -u %s ", this.credentials.getUsername()));
        sb.append(String.format(" -p%s ", this.credentials.getPassword()));
        sb.append(String.format(" -h %s ", this.credentials.getHost()));
        sb.append(String.format(" %s %s ", this.credentials.getDatabase(), filePath));
        String command = sb.toString();
        logger.debug(String.format("CENTROMERE: Executing mysqlimport with command: %s", command));
        String[] commands = new String[]{"/bin/bash", "-c", command};
        try {
            logger.debug(String.format("CENTROMERE: Importing file to MySQL: %s", filePath));
            Process process = Runtime.getRuntime().exec(commands);
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder outputBuilder = new StringBuilder();
            String line = stdIn.readLine();
            while (line != null) {
                logger.debug(line);
                outputBuilder.append(line);
                line = stdIn.readLine();
            }
            stdIn.close();
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder errorBuilder = new StringBuilder();
            line = stdErr.readLine();
            while (line != null) {
                logger.debug(line);
                errorBuilder.append(line);
                line = stdErr.readLine();
            }
            stdErr.close();
            process.waitFor();
            Integer exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new DataImportException(String.format("MongoImport failure for temp file: %s \n%s", filePath, errorBuilder.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataImportException(String.format("Unable to import temp file: %s", filePath));
        }
        logger.debug(String.format("CENTROMERE: MongoImport complete: %s", filePath));
    }

    public MySqlImportTempFileImporter setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
        return this;
    }

    public MySqlImportTempFileImporter setDropCollection(boolean dropCollection) {
        this.dropCollection = dropCollection;
        return this;
    }

    public void doBefore(Object ... args) throws DataImportException {
    }

    public void doAfter(Object ... args) throws DataImportException {
    }
}

