/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.sql;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.oncoblocks.centromere.core.dataimport.AbstractRecordFileWriter;
import org.oncoblocks.centromere.core.dataimport.DataImportException;
import org.oncoblocks.centromere.core.model.Model;

public class MySqlImportTempFileWriter<T extends Model<?>>
extends AbstractRecordFileWriter<T> {
    private String delimiter = "\t";
    private String enclosedBy = "";
    private String escapedBy = "\\\\";
    private String terminatedBy = "\n";
    private List<String> ignoredFields = new ArrayList<String>();

    public void writeRecord(T record) throws DataImportException {
        FileWriter writer = this.getWriter();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean flag = false;
            for (Field field : record.getClass().getDeclaredFields()) {
                Object value;
                if (this.ignoredFields.contains(field.getName())) continue;
                field.setAccessible(true);
                Object object = value = field.get(record) != null ? field.get(record) : null;
                if (value == null) {
                    value = "null";
                } else if (!"".equals(this.enclosedBy) && value instanceof String) {
                    value = ((String)value).replaceAll(this.enclosedBy, this.escapedBy + this.enclosedBy);
                }
                if (flag) {
                    stringBuilder.append(this.delimiter);
                }
                stringBuilder.append(this.enclosedBy).append(value).append(this.enclosedBy);
                flag = true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
        try {
            writer.write(stringBuilder.toString());
            writer.write(this.terminatedBy);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DataImportException(e.getMessage());
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public MySqlImportTempFileWriter setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public String getEnclosedBy() {
        return this.enclosedBy;
    }

    public MySqlImportTempFileWriter setEnclosedBy(String enclosedBy) {
        this.enclosedBy = enclosedBy;
        return this;
    }

    public String getEscapedBy() {
        return this.escapedBy;
    }

    public MySqlImportTempFileWriter setEscapedBy(String escapedBy) {
        this.escapedBy = escapedBy;
        return this;
    }

    public String getTerminatedBy() {
        return this.terminatedBy;
    }

    public MySqlImportTempFileWriter setTerminatedBy(String terminatedBy) {
        this.terminatedBy = terminatedBy;
        return this;
    }

    public List<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    public MySqlImportTempFileWriter setIgnoredFields(List<String> ignoredFields) {
        this.ignoredFields = ignoredFields;
        return this;
    }
}

