/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.sql;

import com.google.common.reflect.TypeToken;
import com.nurkiewicz.jdbcrepository.MissingRowUnmapper;
import com.nurkiewicz.jdbcrepository.RowUnmapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.QueryCriteria;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;
import org.oncoblocks.centromere.sql.sqlbuilder.ComplexTableDescription;
import org.oncoblocks.centromere.sql.sqlbuilder.Condition;
import org.oncoblocks.centromere.sql.sqlbuilder.SqlBuilder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;

public class GenericJdbcRepository<T extends Model<ID>, ID extends Serializable>
implements RepositoryOperations<T, ID> {
    private JdbcTemplate jdbcTemplate;
    private ComplexTableDescription tableDescription;
    private RowMapper<T> rowMapper;
    private RowUnmapper<T> rowUnmapper;
    private final Class<T> model;

    public GenericJdbcRepository(DataSource dataSource, ComplexTableDescription tableDescription, RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper) {
        Assert.notNull((Object)dataSource);
        Assert.notNull((Object)tableDescription);
        Assert.notNull(rowMapper);
        Assert.notNull(rowUnmapper);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.tableDescription = tableDescription;
        this.rowMapper = rowMapper;
        this.rowUnmapper = rowUnmapper;
        this.model = new TypeToken<T>(this.getClass()){}.getRawType();
    }

    public GenericJdbcRepository(DataSource dataSource, ComplexTableDescription tableDescription, RowMapper<T> rowMapper, RowUnmapper<T> rowUnmapper, Class<T> model) {
        Assert.notNull((Object)dataSource);
        Assert.notNull((Object)tableDescription);
        Assert.notNull(rowMapper);
        Assert.notNull(rowUnmapper);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.tableDescription = tableDescription;
        this.rowMapper = rowMapper;
        this.rowUnmapper = rowUnmapper;
        this.model = model;
    }

    public GenericJdbcRepository(DataSource dataSource, ComplexTableDescription tableDescription, RowMapper<T> rowMapper) {
        this(dataSource, tableDescription, rowMapper, (RowUnmapper<T>)new MissingRowUnmapper());
    }

    protected SqlBuilder getSqlBuilder() {
        return new SqlBuilder(this.tableDescription);
    }

    public T findOne(ID id) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        List<Object> identifiers = GenericJdbcRepository.idToObjectList(id);
        List<String> idColumns = this.tableDescription.getIdColumns();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < identifiers.size(); ++i) {
            conditions.add(SqlBuilder.equal(idColumns.get(i), identifiers.get(i)));
        }
        sqlBuilder.where(SqlBuilder.and(conditions.toArray(new Condition[0])));
        String sql = sqlBuilder.toSql();
        Object[] parameters = sqlBuilder.getQueryParameterValues().toArray();
        try {
            return (T)((Model)this.jdbcTemplate.queryForObject(sql, parameters, this.rowMapper));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public List<T> findAll() {
        return this.jdbcTemplate.query(this.getSqlBuilder().toSql(), this.rowMapper);
    }

    public List<T> findAll(Sort sort) {
        SqlBuilder sqlBuilder = this.getSqlBuilder().orderBy(sort);
        return this.jdbcTemplate.query(sqlBuilder.toSql(), this.rowMapper);
    }

    public Page<T> findAll(Pageable pageable) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        if (pageable.getSort() != null) {
            sqlBuilder.orderBy(pageable.getSort());
        }
        sqlBuilder.limit(pageable);
        List objects = this.jdbcTemplate.query(sqlBuilder.toSql(), this.rowMapper);
        Long rowCount = this.count();
        return new PageImpl(objects, pageable, rowCount.longValue());
    }

    public List<T> findAll(Iterable<ID> iterable) {
        ArrayList<T> found = new ArrayList<T>();
        for (Serializable id : iterable) {
            found.add(this.findOne((ID)id));
        }
        return found;
    }

    public long count() {
        String selectAll = this.getSqlBuilder().toSql();
        SqlBuilder sqlBuilder = new SqlBuilder().select("count(*)").from("(" + selectAll + ") a");
        return (Long)this.jdbcTemplate.queryForObject(sqlBuilder.toSql(), Long.class);
    }

    public List<T> find(Iterable<QueryCriteria> queryCriterias) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (QueryCriteria criteria : queryCriterias) {
            if (criteria == null) continue;
            conditionList.add(this.getConditionFromQueryCriteria(criteria));
        }
        sqlBuilder.where(SqlBuilder.and(conditionList.toArray(new Condition[0])));
        return this.jdbcTemplate.query(sqlBuilder.toSql(), sqlBuilder.getQueryParameterValues().toArray(), this.rowMapper);
    }

    public List<T> find(Iterable<QueryCriteria> queryCriterias, Sort sort) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (QueryCriteria criteria : queryCriterias) {
            if (criteria == null) continue;
            conditionList.add(this.getConditionFromQueryCriteria(criteria));
        }
        sqlBuilder.where(SqlBuilder.and(conditionList.toArray(new Condition[0]))).orderBy(sort);
        return this.jdbcTemplate.query(sqlBuilder.toSql(), sqlBuilder.getQueryParameterValues().toArray(), this.rowMapper);
    }

    public Page<T> find(Iterable<QueryCriteria> queryCriterias, Pageable pageable) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (QueryCriteria criteria : queryCriterias) {
            if (criteria == null) continue;
            conditionList.add(this.getConditionFromQueryCriteria(criteria));
        }
        sqlBuilder.where(SqlBuilder.and(conditionList.toArray(new Condition[0])));
        if (pageable.getSort() != null) {
            sqlBuilder.orderBy(pageable.getSort());
        }
        sqlBuilder.limit(pageable);
        List objects = this.jdbcTemplate.query(sqlBuilder.toSql(), sqlBuilder.getQueryParameterValues().toArray(), this.rowMapper);
        Long rowCount = this.count(queryCriterias);
        return new PageImpl(objects, pageable, rowCount.longValue());
    }

    public long count(Iterable<QueryCriteria> queryCriterias) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (QueryCriteria criteria : queryCriterias) {
            if (criteria == null) continue;
            conditionList.add(this.getConditionFromQueryCriteria(criteria));
        }
        sqlBuilder.where(SqlBuilder.and(conditionList.toArray(new Condition[0])));
        String selectWhere = sqlBuilder.toSql();
        SqlBuilder sqlBuilder2 = new SqlBuilder().select("count(*)").from("(" + selectWhere + ") a");
        return (Long)this.jdbcTemplate.queryForObject(sqlBuilder2.toSql(), sqlBuilder.getQueryParameterValues().toArray(), Long.class);
    }

    public Iterable<Object> distinct(String field) {
        return null;
    }

    public Iterable<Object> distinct(String field, Iterable<QueryCriteria> queryCriterias) {
        return null;
    }

    public <S extends T> S insert(S entity) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        Map mappings = this.rowUnmapper.mapColumns(entity);
        final String sql = sqlBuilder.insert(mappings).toSql();
        final Object[] values = sqlBuilder.getQueryParameterValues().toArray();
        final String[] columns = mappings.keySet().toArray(new String[0]);
        sqlBuilder.insert(mappings);
        S created = null;
        if (entity.getId() == null) {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = connection.prepareStatement(sql, columns);
                    for (int i = 0; i < values.length; ++i) {
                        preparedStatement.setObject(i + 1, values[i]);
                    }
                    return preparedStatement;
                }
            }, (KeyHolder)keyHolder);
            Number newId = keyHolder.getKey();
            created = (S)this.findOne((ID)newId);
        } else {
            this.jdbcTemplate.update(sql, values);
            created = entity;
        }
        return created;
    }

    public <S extends T> List<S> insert(Iterable<S> entities) {
        ArrayList<Model> insertedList = new ArrayList<Model>();
        for (Model entity : entities) {
            insertedList.add(this.insert(entity));
        }
        return insertedList;
    }

    public <S extends T> S update(S entity) {
        Map mappings = this.rowUnmapper.mapColumns(entity);
        List<String> idColumns = this.tableDescription.getIdColumns();
        List<Object> identifiers = GenericJdbcRepository.idToObjectList(entity.getId());
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        sqlBuilder.update(mappings);
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < identifiers.size(); ++i) {
            conditions.add(SqlBuilder.equal(idColumns.get(i), identifiers.get(i)));
        }
        sqlBuilder.where(SqlBuilder.and(conditions.toArray(new Condition[0])));
        this.jdbcTemplate.update(sqlBuilder.toSql(), sqlBuilder.getQueryParameterValues().toArray());
        return entity;
    }

    public <S extends T> List<S> update(Iterable<S> entities) {
        ArrayList<Model> updatedList = new ArrayList<Model>();
        for (Model entity : entities) {
            updatedList.add(this.update(entity));
        }
        return updatedList;
    }

    public <S extends T> List<S> save(Iterable<S> iterable) {
        ArrayList<Model> saved = new ArrayList<Model>();
        for (Model s : iterable) {
            saved.add(this.save((S)s));
        }
        return saved;
    }

    public <S extends T> S save(S s) {
        if (this.exists(s.getId())) {
            return this.update(s);
        }
        return this.insert(s);
    }

    public void delete(Iterable<? extends T> iterable) {
        for (Model t : iterable) {
            this.delete((ID)t.getId());
        }
    }

    public void delete(T t) {
        this.delete((ID)t.getId());
    }

    public void delete(ID id) {
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        List<Object> identifiers = GenericJdbcRepository.idToObjectList(id);
        List<String> idColumns = this.tableDescription.getIdColumns();
        sqlBuilder.delete();
        for (int i = 0; i < identifiers.size(); ++i) {
            sqlBuilder.where(SqlBuilder.equal(idColumns.get(i), identifiers.get(i)));
        }
        String sql = sqlBuilder.toSql();
        Object[] parameters = sqlBuilder.getQueryParameterValues().toArray();
        this.jdbcTemplate.update(sql, parameters);
    }

    public void deleteAll() {
        this.jdbcTemplate.execute("DELETE FROM " + this.tableDescription.getTableName());
    }

    public void truncateTable() {
        this.jdbcTemplate.execute("TRUNCATE TABLE " + this.tableDescription.getTableName());
    }

    protected static <ID> List<Object> idToObjectList(ID id) {
        if (id instanceof Object[]) {
            return Arrays.asList((Object[])id);
        }
        return Collections.singletonList(id);
    }

    protected Condition getConditionFromQueryCriteria(QueryCriteria criteria) {
        switch (criteria.getEvaluation()) {
            case EQUALS: {
                return SqlBuilder.equal(criteria.getKey(), criteria.getValue());
            }
            case NOT_EQUALS: {
                return SqlBuilder.notEqual(criteria.getKey(), criteria.getValue());
            }
            case IN: {
                return SqlBuilder.in(criteria.getKey(), (Object[])criteria.getValue());
            }
            case NOT_IN: {
                return SqlBuilder.notIn(criteria.getKey(), (Object[])criteria.getValue());
            }
            case IS_NULL: {
                return SqlBuilder.isNull(criteria.getKey());
            }
            case NOT_NULL: {
                return SqlBuilder.notNull(criteria.getKey());
            }
        }
        return SqlBuilder.equal(criteria.getKey(), criteria.getValue());
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ComplexTableDescription getTableDescription() {
        return this.tableDescription;
    }

    public RowMapper<T> getRowMapper() {
        return this.rowMapper;
    }

    public RowUnmapper<T> getRowUnmapper() {
        return this.rowUnmapper;
    }

    public Class<T> getModel() {
        return this.model;
    }
}

