/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.sql.sqlbuilder;

import java.util.ArrayList;
import java.util.List;
import org.oncoblocks.centromere.sql.sqlbuilder.Condition;

public class Conditions {
    private final Operation operation;
    private final String sql;
    private final List<Object> values;

    public Conditions(Operation operation, Condition ... conditions) {
        this.operation = operation;
        this.values = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        String separator = " AND ";
        if (operation.equals((Object)Operation.OR)) {
            separator = " OR ";
        }
        boolean flag = false;
        for (Condition condition : conditions) {
            if (flag) {
                builder.append(separator);
            }
            flag = true;
            builder.append(condition.getClause());
            if (condition.getValue() == null) continue;
            this.values.add(condition.getValue());
        }
        this.sql = builder.toString();
    }

    public Conditions(Operation operation, Conditions ... conditions) {
        this.operation = operation;
        this.values = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        String separator = " AND ";
        if (operation.equals((Object)Operation.OR)) {
            separator = " OR ";
        }
        boolean flag = false;
        for (Conditions c : conditions) {
            if (flag) {
                builder.append(separator);
            }
            flag = true;
            builder.append(" ( " + c.getSql() + " ) ");
            this.values.addAll(c.getValues());
        }
        this.sql = builder.toString();
    }

    public String getSql() {
        return this.sql;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static enum Operation {
        AND,
        OR;

    }
}

