/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.sql.sqlbuilder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SortOrder;
import org.oncoblocks.centromere.core.repository.Evaluation;
import org.oncoblocks.centromere.sql.sqlbuilder.ComplexTableDescription;
import org.oncoblocks.centromere.sql.sqlbuilder.Condition;
import org.oncoblocks.centromere.sql.sqlbuilder.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SqlBuilder {
    private String tableName;
    private String selectClause = "*";
    private String fromClause = "";
    private String whereClause = "";
    private String groupByClause = "";
    private String orderByClause = "";
    private String limitClause = "";
    private String insertClause = "";
    private String updateClause = "";
    private Mode mode = Mode.SELECT;
    private List<String> idColumns;
    private LinkedHashMap<String, SortOrder> sorts;
    private List<Object> queryParameterValues;
    private static final Logger logger = LoggerFactory.getLogger(SqlBuilder.class);

    public SqlBuilder(ComplexTableDescription tableDescription) {
        this.tableName = tableDescription.getTableName();
        this.selectClause = tableDescription.getSelectClause();
        this.fromClause = tableDescription.getFromClause();
        this.groupByClause = tableDescription.getGroupByClause();
        this.idColumns = tableDescription.getIdColumns();
        this.queryParameterValues = new ArrayList<Object>();
        this.sorts = new LinkedHashMap();
    }

    public SqlBuilder(String tableName) {
        this.tableName = tableName;
        this.fromClause = tableName;
    }

    public SqlBuilder() {
    }

    public String getSelectClause() {
        return "SELECT " + this.selectClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public SqlBuilder select(String clause) {
        this.selectClause = clause;
        return this;
    }

    public SqlBuilder insert(Map<String, Object> parameters) {
        StringBuilder columnString = new StringBuilder(" (");
        StringBuilder valueString = new StringBuilder(" VALUES (");
        boolean flag = false;
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            if (flag) {
                columnString.append(",");
                valueString.append(",");
            }
            flag = true;
            columnString.append((Object)param.getKey());
            valueString.append("?");
            this.queryParameterValues.add(param.getValue());
        }
        columnString.append(") ");
        valueString.append(") ");
        this.insertClause = this.tableName + columnString.toString() + valueString.toString();
        this.mode = Mode.INSERT;
        return this;
    }

    public String getInsertClause() {
        return "INSERT INTO " + this.insertClause;
    }

    public SqlBuilder update(Map<String, Object> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean flag = false;
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            if (flag) {
                stringBuilder.append(", ");
            }
            flag = true;
            stringBuilder.append(param.getKey() + " = ?");
            this.queryParameterValues.add(param.getValue());
        }
        this.updateClause = this.tableName + " SET " + stringBuilder.toString();
        this.mode = Mode.UPDATE;
        return this;
    }

    public String getUpdateClause() {
        return "UPDATE " + this.updateClause;
    }

    public SqlBuilder delete() {
        this.fromClause = " " + this.tableName + " ";
        this.mode = Mode.DELETE;
        return this;
    }

    public String getFromClause() {
        return " FROM " + this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public SqlBuilder from(String clause) {
        this.fromClause = clause;
        return this;
    }

    public String getWhereClause() {
        return this.whereClause.equals("") ? this.whereClause : " WHERE " + this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public SqlBuilder where(Conditions conditions) {
        this.whereClause = conditions.getSql();
        this.queryParameterValues.addAll(conditions.getValues());
        return this;
    }

    public SqlBuilder where(Condition condition) {
        this.whereClause = condition.getClause();
        this.queryParameterValues.add(condition.getValue());
        return this;
    }

    public static Conditions and(Condition ... conditions) {
        return new Conditions(Conditions.Operation.AND, conditions);
    }

    public static Conditions and(Conditions ... conditions) {
        return new Conditions(Conditions.Operation.AND, conditions);
    }

    public static Conditions or(Condition ... conditions) {
        return new Conditions(Conditions.Operation.OR, conditions);
    }

    public static Conditions or(Conditions ... conditions) {
        return new Conditions(Conditions.Operation.OR, conditions);
    }

    public static Condition equal(String column, Object value) {
        return new Condition(column, value, Evaluation.EQUALS);
    }

    public static Condition notEqual(String column, Object value) {
        return new Condition(column, value, Evaluation.NOT_EQUALS);
    }

    public static Condition in(String column, Object[] value) {
        return new Condition(column, value, Evaluation.IN);
    }

    public static Condition notIn(String column, Object[] value) {
        return new Condition(column, value, Evaluation.NOT_IN);
    }

    public static Condition isNull(String column) {
        return new Condition(column, null, Evaluation.IS_NULL);
    }

    public static Condition notNull(String column) {
        return new Condition(column, null, Evaluation.NOT_NULL);
    }

    public String getGroupByClause() {
        return this.groupByClause.equals("") ? this.groupByClause : " GROUP BY " + this.groupByClause;
    }

    public void setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
    }

    public SqlBuilder groupBy(String ... columns) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String column : columns) {
            if (flag) {
                builder.append(", ");
            }
            flag = true;
            builder.append(column);
        }
        this.groupByClause = builder.toString();
        return this;
    }

    public String getOrderByClause() {
        return "".equals(this.orderByClause) ? this.orderByClause : " ORDER BY " + this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public SqlBuilder orderBy(Sort sort) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (Sort.Order order : sort) {
            if (flag) {
                builder.append(", ");
            }
            flag = true;
            builder.append(order.getProperty() + " " + order.getDirection().toString());
        }
        this.orderByClause = builder.toString();
        return this;
    }

    public SqlBuilder orderBy(Sort.Order ... orders) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (Sort.Order order : orders) {
            if (flag) {
                builder.append(", ");
            }
            flag = true;
            builder.append(order.getProperty() + " " + order.getDirection().toString());
        }
        this.orderByClause = builder.toString();
        return this;
    }

    public SqlBuilder orderBy(String column, Sort.Direction direction) {
        this.orderByClause = column + " " + direction.toString();
        return this;
    }

    public SqlBuilder orderBy(String column) {
        this.orderByClause = column + " ASC";
        return this;
    }

    public String getLimitClause() {
        return "".equals(this.limitClause) ? this.limitClause : " LIMIT " + this.limitClause;
    }

    public void setLimitClause(String limitClause) {
        this.limitClause = limitClause;
    }

    public SqlBuilder limit(Integer offset, Integer count) {
        this.limitClause = offset.toString() + "," + count.toString();
        return this;
    }

    public SqlBuilder limit(Integer count) {
        this.limitClause = count.toString();
        return this;
    }

    public SqlBuilder limit(Pageable pageable) {
        this.limitClause = String.valueOf(pageable.getOffset()) + "," + String.valueOf(pageable.getPageSize());
        return this;
    }

    public String getDeleteClause() {
        return "DELETE ";
    }

    public String toSql() {
        String sql;
        switch (this.mode) {
            case SELECT: {
                sql = this.getSelectClause() + this.getFromClause() + this.getWhereClause() + this.getGroupByClause() + this.getOrderByClause() + this.getLimitClause();
                break;
            }
            case INSERT: {
                sql = this.getInsertClause();
                break;
            }
            case UPDATE: {
                sql = this.getUpdateClause() + this.getWhereClause();
                break;
            }
            case DELETE: {
                sql = this.getDeleteClause() + this.getFromClause() + this.getWhereClause();
                break;
            }
            default: {
                sql = this.getSelectClause() + this.getFromClause() + this.getWhereClause() + this.getGroupByClause() + this.getOrderByClause() + this.getLimitClause();
            }
        }
        return sql;
    }

    public List<Object> getQueryParameterValues() {
        return this.queryParameterValues;
    }

    private static enum Mode {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

