/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.QueryCriteria;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;
import org.oncoblocks.centromere.web.controller.FilterableResource;
import org.oncoblocks.centromere.web.controller.RequestUtils;
import org.oncoblocks.centromere.web.controller.ResponseEnvelope;
import org.oncoblocks.centromere.web.controller.WebServicesController;
import org.oncoblocks.centromere.web.exceptions.ResourceNotFoundException;
import org.oncoblocks.centromere.web.util.ApiMediaTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractApiController<T extends Model<ID>, ID extends Serializable>
implements WebServicesController<T, ID>,
ApplicationContextAware {
    private final RepositoryOperations<T, ID> repository;
    private final ResourceAssemblerSupport<T, FilterableResource> assembler;
    private final Class<T> model;
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(AbstractApiController.class);

    public AbstractApiController(RepositoryOperations<T, ID> repository, Class<T> model, ResourceAssemblerSupport<T, FilterableResource> assembler) {
        this.repository = repository;
        this.model = model;
        this.assembler = assembler;
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/hal+json", "application/json", "application/hal+xml", "application/xml", "text/plain"})
    public HttpEntity<?> findById(@PathVariable ID id, HttpServletRequest request) {
        Set<String> fields = RequestUtils.getFilteredFieldsFromRequest(request);
        Set<String> exclude = RequestUtils.getExcludedFieldsFromRequest(request);
        Model entity = (Model)this.repository.findOne(id);
        if (entity == null) {
            throw new ResourceNotFoundException();
        }
        ResponseEnvelope envelope = null;
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            FilterableResource resource = (FilterableResource)this.assembler.toResource((Object)entity);
            envelope = new ResponseEnvelope((Object)resource, fields, exclude);
        } else {
            envelope = new ResponseEnvelope(entity, fields, exclude);
        }
        return new ResponseEntity((Object)envelope, HttpStatus.OK);
    }

    @Override
    @RequestMapping(value={"/distinct"}, method={RequestMethod.GET}, produces={"application/hal+json", "application/json", "application/hal+xml", "application/xml", "text/plain"})
    public HttpEntity<?> findDistinct(@RequestParam String field, HttpServletRequest request) {
        List<QueryCriteria> queryCriterias = RequestUtils.getQueryCriteriaFromRequest(this.model, request);
        List distinct = (List)this.repository.distinct(field, queryCriterias);
        ResponseEnvelope envelope = null;
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            Link selfLink = new Link(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.getClass()).slash((Object)"distinct")).toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""), "self");
            Resources resources = new Resources((Iterable)distinct, new Link[0]);
            resources.add(selfLink);
            envelope = new ResponseEnvelope(resources);
        } else {
            envelope = new ResponseEnvelope(distinct);
        }
        return new ResponseEntity((Object)envelope, HttpStatus.OK);
    }

    @Override
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json", "application/hal+xml", "application/xml", "text/plain"})
    public HttpEntity<?> find(@PageableDefault(size=1000) Pageable pageable, PagedResourcesAssembler<T> pagedResourcesAssembler, HttpServletRequest request) {
        ResponseEnvelope envelope;
        Set<String> fields = RequestUtils.getFilteredFieldsFromRequest(request);
        Set<String> exclude = RequestUtils.getExcludedFieldsFromRequest(request);
        pageable = RequestUtils.remapPageable(pageable, this.model);
        Map parameterMap = request.getParameterMap();
        List<QueryCriteria> criterias = RequestUtils.getQueryCriteriaFromRequest(this.model, request);
        String mediaType = request.getHeader("Accept");
        Link selfLink = new Link(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.getClass()).slash((Object)"")).toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""), "self");
        if (parameterMap.containsKey("page") || parameterMap.containsKey("size")) {
            Page page = this.repository.find(criterias, pageable);
            if (ApiMediaTypes.isHalMediaType(mediaType)) {
                PagedResources pagedResources = pagedResourcesAssembler.toResource(page, this.assembler, selfLink);
                envelope = new ResponseEnvelope(pagedResources, fields, exclude);
            } else {
                envelope = new ResponseEnvelope(page, fields, exclude);
            }
        } else {
            Sort sort = pageable.getSort();
            List entities = null;
            entities = sort != null ? (List)this.repository.find(criterias, sort) : (List)this.repository.find(criterias);
            if (ApiMediaTypes.isHalMediaType(mediaType)) {
                List resourceList = this.assembler.toResources((Iterable)entities);
                Resources resources = new Resources((Iterable)resourceList, new Link[0]);
                resources.add(selfLink);
                envelope = new ResponseEnvelope(resources, fields, exclude);
            } else {
                envelope = new ResponseEnvelope(entities, fields, exclude);
            }
        }
        return new ResponseEntity((Object)envelope, HttpStatus.OK);
    }

    @Override
    @RequestMapping(value={"", "/**"}, method={RequestMethod.HEAD})
    public HttpEntity<?> head(HttpServletRequest request) {
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    @RequestMapping(method={RequestMethod.OPTIONS})
    public HttpEntity<?> options(HttpServletRequest request) {
        return new ResponseEntity(HttpStatus.OK);
    }

    public RepositoryOperations<T, ID> getRepository() {
        return this.repository;
    }

    public ResourceAssemblerSupport<T, FilterableResource> getAssembler() {
        return this.assembler;
    }

    public Class<T> getModel() {
        return this.model;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

