/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.controller;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;
import org.oncoblocks.centromere.web.controller.AbstractApiController;
import org.oncoblocks.centromere.web.controller.FilterableResource;
import org.oncoblocks.centromere.web.exceptions.RequestFailureException;
import org.oncoblocks.centromere.web.exceptions.ResourceNotFoundException;
import org.oncoblocks.centromere.web.util.ApiMediaTypes;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class CrudApiController<T extends Model<ID>, ID extends Serializable>
extends AbstractApiController<T, ID> {
    public CrudApiController(RepositoryOperations<T, ID> repository, Class<T> model, ResourceAssemblerSupport<T, FilterableResource> assembler) {
        super(repository, model, assembler);
    }

    @Override
    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json", "application/hal+json", "application/hal+xml", "application/xml", "text/plain"})
    public HttpEntity<?> create(@RequestBody T entity, HttpServletRequest request) {
        Model created = (Model)this.getRepository().insert(entity);
        if (created == null) {
            throw new RequestFailureException(40003, "There was a problem creating the record.", "", "");
        }
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            FilterableResource resource = (FilterableResource)this.getAssembler().toResource((Object)created);
            return new ResponseEntity((Object)resource, HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)created, HttpStatus.CREATED);
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, produces={"application/json", "application/hal+json", "application/hal+xml", "application/xml", "text/plain"})
    public HttpEntity<?> update(@RequestBody T entity, @PathVariable ID id, HttpServletRequest request) {
        if (!this.getRepository().exists(id)) {
            throw new ResourceNotFoundException();
        }
        Model updated = (Model)this.getRepository().update(entity);
        if (updated == null) {
            throw new RequestFailureException(40004, "There was a problem updating the record.", "", "");
        }
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            FilterableResource resource = (FilterableResource)this.getAssembler().toResource((Object)updated);
            return new ResponseEntity((Object)resource, HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)updated, HttpStatus.CREATED);
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public HttpEntity<?> delete(@PathVariable ID id, HttpServletRequest request) {
        this.getRepository().delete(id);
        return new ResponseEntity(HttpStatus.OK);
    }
}

