/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.controller;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.oncoblocks.centromere.core.model.ForeignKey;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.web.controller.FilterableResource;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;

public class ModelResourceAssembler<T extends Model<?>>
extends ResourceAssemblerSupport<T, FilterableResource> {
    private final EntityLinks entityLinks;
    private final Class<?> modelController;
    private final Class<T> model;

    public ModelResourceAssembler(Class<?> controllerClass, Class<T> model, EntityLinks entityLinks) {
        super(controllerClass, FilterableResource.class);
        this.modelController = controllerClass;
        this.model = model;
        this.entityLinks = entityLinks;
    }

    public FilterableResource toResource(T t) {
        FilterableResource<T> resource = new FilterableResource<T>(t, new Link[0]);
        resource.add(this.entityLinks.linkToSingleResource(this.model, (Object)t.getId()).withSelfRel());
        List<Link> links = this.addLinks(new ArrayList<Link>());
        links.addAll(this.addForeignKeyLinks(t));
        resource.add(links);
        return resource;
    }

    private List<Link> addForeignKeyLinks(T t) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Field field : this.model.getDeclaredFields()) {
            Link link;
            block7: {
                String fieldName;
                ForeignKey fk = field.getAnnotation(ForeignKey.class);
                if (fk == null) continue;
                if (fk.model() == null) {
                    throw new RuntimeException(String.format("ForeignKey annotation for class %s does not contain any class reference!", this.model.getName()));
                }
                Class fkCLass = fk.model();
                String relName = fk.rel().equals("") ? field.getName() : fk.rel();
                String string = fieldName = fk.field().equals("") ? field.getName() : fk.field();
                if (!Model.class.isAssignableFrom(fkCLass)) continue;
                link = null;
                try {
                    HashMap<String, Object> map;
                    field.setAccessible(true);
                    if (fk.relationship().equals((Object)ForeignKey.Relationship.MANY_TO_ONE) && !field.getType().isArray() && !Collection.class.isAssignableFrom(field.getType())) {
                        link = this.entityLinks.linkToSingleResource(fkCLass, field.get(t)).withRel(relName);
                        break block7;
                    }
                    if (fk.relationship().equals((Object)ForeignKey.Relationship.ONE_TO_MANY) && (field.getType().isArray() || Collection.class.isAssignableFrom(field.getType()))) {
                        map = new HashMap<String, Object>();
                        map.put(fieldName, field.get(t));
                        link = this.entityLinks.linkToCollectionResource(fkCLass).expand(map).withRel(relName);
                        break block7;
                    }
                    if (fk.relationship().equals((Object)ForeignKey.Relationship.MANY_TO_MANY) && (field.getType().isArray() || Collection.class.isAssignableFrom(field.getType()))) {
                        map = new HashMap();
                        map.put(fieldName, field.get(t));
                        link = this.entityLinks.linkToCollectionResource(fkCLass).expand(map).withRel(relName);
                        break block7;
                    }
                    throw new RuntimeException(String.format("Unable to determine correct link format for field %s of class %s", field.getName(), this.model.getName()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private List<Link> addLinks(List<Link> links) {
        return links;
    }

    public EntityLinks getEntityLinks() {
        return this.entityLinks;
    }

    public Class<?> getModelController() {
        return this.modelController;
    }

    public Class<T> getModel() {
        return this.model;
    }
}

