/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.oncoblocks.centromere.web.security.TokenDetails;
import org.oncoblocks.centromere.web.security.TokenOperations;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class BasicTokenUtils
implements TokenOperations {
    private final String key;
    private Long tokenLifespan = 86400000L;

    public BasicTokenUtils(String key) {
        this.key = key;
    }

    @Override
    public String createToken(UserDetails userDetails) {
        long expires = System.currentTimeMillis() + this.tokenLifespan;
        StringBuilder tokenBuilder = new StringBuilder();
        tokenBuilder.append(userDetails.getUsername());
        tokenBuilder.append(":");
        tokenBuilder.append(expires);
        tokenBuilder.append(":");
        tokenBuilder.append(this.computeSignature(userDetails, expires));
        return tokenBuilder.toString();
    }

    @Override
    public String computeSignature(UserDetails userDetails, long expires) {
        MessageDigest digest;
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append(userDetails.getUsername());
        signatureBuilder.append(":");
        signatureBuilder.append(expires);
        signatureBuilder.append(":");
        signatureBuilder.append(userDetails.getPassword());
        signatureBuilder.append(":");
        signatureBuilder.append(this.key);
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm available!");
        }
        return new String(Hex.encodeHex((byte[])digest.digest(signatureBuilder.toString().getBytes())));
    }

    @Override
    public String getUserNameFromToken(String authToken) {
        if (null == authToken) {
            return null;
        }
        String[] bits = authToken.split(":");
        return bits[0];
    }

    @Override
    public boolean validateToken(String authToken, UserDetails userDetails) {
        String[] bits = authToken.split(":");
        long expires = Long.parseLong(bits[1]);
        String signature = bits[2];
        if (expires < System.currentTimeMillis()) {
            return false;
        }
        return signature.equals(this.computeSignature(userDetails, expires));
    }

    public void setTokenLifespanDays(Long days) {
        Assert.notNull((Object)days, (String)"Number of days must not be null.");
        if (days < 1L) {
            throw new IllegalArgumentException("Number of days must be greater than zero.");
        }
        this.tokenLifespan = 86400000L * days;
    }

    public void setTokenLifespanHours(Long hours) {
        Assert.notNull((Object)hours, (String)"Number of hours must not be null.");
        if (hours < 1L) {
            throw new IllegalArgumentException("Number of hours must be greater than zero.");
        }
        this.tokenLifespan = 3600000L * hours;
    }

    public TokenDetails createTokenAndDetails(UserDetails userDetails) {
        String token = this.createToken(userDetails);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(14, this.tokenLifespan.intValue());
        Date expires = calendar.getTime();
        return new TokenDetails(token, userDetails.getUsername(), now, expires);
    }
}

