/*
 * Copyright 2016 William Oemler, Blueprint Medicines
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.oncoblocks.centromere.web.exceptions;

import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

/**
 * Base exception class for web services.  Generates a {@link RestError} object, that will be returned
 *   in the HTTP response when the exception is thrown.
 * 
 * @author woemler
 */
public class RestException extends RuntimeException {

	private HttpStatus status;
	private Integer code;
	private String message;
	private String developerMessage;
	private String moreInfoUrl;

	public RestException(HttpStatus status, Integer code, String message){
		this(status, code, message, null, null);
	}
	
	public RestException(HttpStatus status, Integer code, String message, String developerMessage){
		this(status, code, message, developerMessage, null);
	}
	
	public RestException(HttpStatus status, Integer code, String message, String developerMessage, String moreInfoUrl){
		Assert.notNull(status,"HttpStatus argument cannot be null.");
		this.status = status;
		this.code = code;
		this.message = message;
		this.developerMessage = developerMessage;
		this.moreInfoUrl = moreInfoUrl;
	}

	public HttpStatus getStatus() {
		return status;
	}

	public void setStatus(HttpStatus status) {
		this.status = status;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getDeveloperMessage() {
		return developerMessage;
	}

	public void setDeveloperMessage(String developerMessage) {
		this.developerMessage = developerMessage;
	}

	public String getMoreInfoUrl() {
		return moreInfoUrl;
	}

	public void setMoreInfoUrl(String moreInfoUrl) {
		this.moreInfoUrl = moreInfoUrl;
	}

	public RestError getRestError(){
		return new RestError(this.status, this.code, this.message, this.developerMessage, this.moreInfoUrl);
	}
	
}
