/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.config;

import javax.servlet.Filter;
import org.oncoblocks.centromere.web.security.AuthenticationTokenProcessingFilter;
import org.oncoblocks.centromere.web.security.BasicTokenUtils;
import org.oncoblocks.centromere.web.security.TokenOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableWebMvcSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static Logger logger = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private UserDetailsService userService;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userService).passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
    }

    @Configuration
    @Order(value=2)
    public static class BasicWebSecurtiyConfig
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).httpBasic().and()).csrf().disable();
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiTokenAuthenticationConfig
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private UserDetailsService userService;
        @Autowired
        private Environment env;

        @Bean
        public TokenOperations tokenUtils() {
            BasicTokenUtils tokenUtils = new BasicTokenUtils(this.env.getRequiredProperty("centromere.security.token"));
            try {
                tokenUtils.setTokenLifespanHours(Long.parseLong(this.env.getRequiredProperty("centromere.security.token-lifespan-hours")));
            }
            catch (NumberFormatException e) {
                try {
                    tokenUtils.setTokenLifespanDays(Long.parseLong(this.env.getRequiredProperty("centromere.security.token-lifespan-days")));
                }
                catch (NumberFormatException ex) {
                    logger.warn("[CENTROMERE] Token lifespan not properly configured.  Reverting to default configuration");
                    tokenUtils.setTokenLifespanDays(1L);
                }
            }
            return tokenUtils;
        }

        @Bean
        public AuthenticationTokenProcessingFilter authenticationTokenProcessingFilter() {
            return new AuthenticationTokenProcessingFilter(this.tokenUtils(), this.userService);
        }

        protected void configure(HttpSecurity http) throws Exception {
            String secureUrl = this.env.getRequiredProperty("centromere.security.secure-url");
            Boolean secureRead = Boolean.parseBoolean(this.env.getRequiredProperty("centromere.security.secure-read"));
            Boolean secureWrite = Boolean.parseBoolean(this.env.getRequiredProperty("centromere.security.secure-write"));
            logger.info(String.format("[CENTROMERE] Secure URL: %s", secureUrl));
            logger.info(String.format("[CENTROMERE] Secure Read: %s", secureRead.toString()));
            logger.info(String.format("[CENTROMERE] Secure Write: %s", secureWrite.toString()));
            if (secureRead.booleanValue() && secureWrite.booleanValue()) {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilterBefore((Filter)this.authenticationTokenProcessingFilter(), UsernamePasswordAuthenticationFilter.class).antMatcher(secureUrl).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.POST, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.PUT, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.DELETE, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.PATCH, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.OPTIONS, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.HEAD, new String[]{secureUrl})).fullyAuthenticated().and()).csrf().disable();
            } else if (!secureRead.booleanValue() && !secureWrite.booleanValue()) {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilterBefore((Filter)this.authenticationTokenProcessingFilter(), UsernamePasswordAuthenticationFilter.class).antMatcher(secureUrl).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.POST, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.PUT, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.DELETE, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.PATCH, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.HEAD, new String[]{secureUrl})).permitAll().and()).csrf().disable();
            } else {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilterBefore((Filter)this.authenticationTokenProcessingFilter(), UsernamePasswordAuthenticationFilter.class).antMatcher(secureUrl).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.POST, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.PUT, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.DELETE, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.PATCH, new String[]{secureUrl})).fullyAuthenticated().antMatchers(HttpMethod.OPTIONS, new String[]{secureUrl})).permitAll().antMatchers(HttpMethod.HEAD, new String[]{secureUrl})).permitAll().and()).csrf().disable();
            }
        }
    }
}

