/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.config;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.oncoblocks.centromere.web.exceptions.RestExceptionHandler;
import org.oncoblocks.centromere.web.util.ApiMediaTypes;
import org.oncoblocks.centromere.web.util.CorsFilter;
import org.oncoblocks.centromere.web.util.FilteringJackson2HttpMessageConverter;
import org.oncoblocks.centromere.web.util.FilteringTextMessageConverter;
import org.oncoblocks.centromere.web.util.StringToAttributeConverter;
import org.oncoblocks.centromere.web.util.StringToSourcedAliasConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.format.FormatterRegistry;
import org.springframework.hateoas.config.EnableEntityLinks;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
@EnableSpringDataWebSupport
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@EnableEntityLinks
@ComponentScan(basePackageClasses={RestExceptionHandler.class})
public class WebServicesConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private Environment env;
    private static final Logger logger = LoggerFactory.getLogger(WebServicesConfig.class);

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FilteringJackson2HttpMessageConverter jsonConverter = new FilteringJackson2HttpMessageConverter();
        jsonConverter.setSupportedMediaTypes(ApiMediaTypes.getJsonMediaTypes());
        converters.add((HttpMessageConverter<?>)jsonConverter);
        MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
        xmlConverter.setSupportedMediaTypes(ApiMediaTypes.getXmlMediaTypes());
        XStreamMarshaller xStreamMarshaller = new XStreamMarshaller();
        xmlConverter.setMarshaller((Marshaller)xStreamMarshaller);
        xmlConverter.setUnmarshaller((Unmarshaller)xStreamMarshaller);
        converters.add((HttpMessageConverter<?>)xmlConverter);
        FilteringTextMessageConverter filteringTextMessageConverter = new FilteringTextMessageConverter(new MediaType("text", "plain", Charset.forName("utf-8")));
        filteringTextMessageConverter.setDelimiter("\t");
        converters.add((HttpMessageConverter<?>)filteringTextMessageConverter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public CorsFilter corsFilter() {
        return new CorsFilter();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StringToAttributeConverter());
        registry.addConverter((Converter)new StringToSourcedAliasConverter());
        super.addFormatters(registry);
    }

    @Bean
    public EmbeddedServletContainerCustomizer servletContainerCustomizer() {
        return configurableEmbeddedServletContainer -> ((TomcatEmbeddedServletContainerFactory)configurableEmbeddedServletContainer).addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

            public void customize(Connector connector) {
                AbstractHttp11Protocol httpProtocol = (AbstractHttp11Protocol)connector.getProtocolHandler();
                httpProtocol.setCompression("on");
                httpProtocol.setCompressionMinSize(256);
                String mimeTypes = httpProtocol.getCompressableMimeTypes();
                String mimeTypesWithJson = mimeTypes + "," + "application/json";
                httpProtocol.setCompressableMimeTypes(mimeTypesWithJson);
            }
        }});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        if ("true".equals(this.env.getRequiredProperty("centromere.web.enable-static-content").toLowerCase())) {
            registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"/static/"});
            if (this.env.getRequiredProperty("centromere.web.home-page") != null && !"".equals(this.env.getRequiredProperty("centromere.web.home-page")) && this.env.getRequiredProperty("centromere.web.home-page-location") != null && !"".equals(this.env.getRequiredProperty("centromere.web.home-page"))) {
                registry.addResourceHandler(new String[]{this.env.getRequiredProperty("centromere.web.home-page")}).addResourceLocations(new String[]{this.env.getRequiredProperty("centromere.web.home-page-location")});
                logger.info(String.format("[CENTROMERE] Static home page configured at URL: /%s", this.env.getRequiredProperty("centromere.web.home-page")));
            } else {
                logger.warn("[CENTROMERE] Static home page location not properly configured.");
            }
        }
    }
}

