/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.documentation;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.oncoblocks.centromere.core.repository.QueryParameterDescriptor;
import org.oncoblocks.centromere.web.controller.AbstractApiController;
import org.oncoblocks.centromere.web.controller.RequestUtils;
import org.oncoblocks.centromere.web.exceptions.ApiDocumentationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

public class ModelParameterBuilderPlugin
implements OperationBuilderPlugin {
    @Autowired
    private TypeResolver typeResolver;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String FIND_METHOD = "find";
    private static final Logger logger = LoggerFactory.getLogger(ModelParameterBuilderPlugin.class);

    public void apply(OperationContext context) {
        Object controller = this.applicationContext.getBean(context.getHandlerMethod().getBeanType());
        if (controller == null) {
            throw new ApiDocumentationException(String.format("Controller bean is null: %s", context.getHandlerMethod().getBeanType().getName()));
        }
        if (context.getHandlerMethod().getMethod().getDeclaringClass().equals(AbstractApiController.class) && FIND_METHOD.equals(context.getHandlerMethod().getMethod().getName())) {
            Class model = ((AbstractApiController)controller).getModel();
            Map<String, QueryParameterDescriptor> paramMap = RequestUtils.getAvailableQueryParameters(model);
            Operation operation = context.operationBuilder().build();
            List parameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
            for (QueryParameterDescriptor descriptor : paramMap.values()) {
                parameters.add(this.createParameterFromDescriptior(descriptor));
            }
            context.operationBuilder().parameters(parameters);
        }
    }

    public boolean supports(DocumentationType documentationType) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)documentationType);
    }

    private Parameter createParameterFromDescriptior(QueryParameterDescriptor descriptor) {
        return new ParameterBuilder().name(descriptor.getParamName()).type(this.typeResolver.resolve((Type)this.typeResolver.resolve((Type)descriptor.getType(), new Type[0]), new Type[0])).modelRef((ModelReference)new ModelRef("string")).parameterType("query").required(false).description(String.format("Query against the '%s' field.", descriptor.getFieldName())).defaultValue("").allowMultiple(false).parameterAccess("").build();
    }
}

