/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.controller;

import com.google.common.reflect.TypeToken;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.QueryCriteria;
import org.oncoblocks.centromere.core.repository.RepositoryOperations;
import org.oncoblocks.centromere.web.controller.FilterableResource;
import org.oncoblocks.centromere.web.controller.ModelResourceAssembler;
import org.oncoblocks.centromere.web.controller.RequestUtils;
import org.oncoblocks.centromere.web.controller.ResponseEnvelope;
import org.oncoblocks.centromere.web.controller.WebServicesController;
import org.oncoblocks.centromere.web.exceptions.InvalidParameterException;
import org.oncoblocks.centromere.web.exceptions.ResourceNotFoundException;
import org.oncoblocks.centromere.web.exceptions.RestError;
import org.oncoblocks.centromere.web.util.ApiMediaTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractApiController<T extends Model<ID>, ID extends Serializable>
implements WebServicesController<T, ID>,
ApplicationContextAware {
    private final RepositoryOperations<T, ID> repository;
    private final ResourceAssemblerSupport<T, FilterableResource> assembler;
    private final Class<T> model;
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(AbstractApiController.class);

    public AbstractApiController(RepositoryOperations<T, ID> repository, Class<T> model, ResourceAssemblerSupport<T, FilterableResource> assembler) {
        this.repository = repository;
        this.model = model;
        this.assembler = assembler;
    }

    public AbstractApiController(RepositoryOperations<T, ID> repository, EntityLinks entityLinks) {
        this.repository = repository;
        TypeToken typeToken = new TypeToken<T>(this.getClass()){};
        this.model = typeToken.getRawType();
        this.assembler = new ModelResourceAssembler<T>(this.getClass(), this.model, entityLinks);
    }

    @Override
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="List of fields to be included in response objects", dataType="string", paramType="query"), @ApiImplicitParam(name="exclude", value="List of fields to be excluded from response objects", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Invalid parameters", response=RestError.class), @ApiResponse(code=401, message="Unauthorized", response=RestError.class), @ApiResponse(code=404, message="Record not found.", response=RestError.class)})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/hal+json", "application/json", "application/hal+xml", "application/xml", "text/plain"})
    public ResponseEntity<ResponseEnvelope<T>> findById(@ApiParam(name="id", value="Model record primary id.") @PathVariable ID id, HttpServletRequest request) {
        if (RequestUtils.requestContainsNonDefaultParameters(RequestUtils.findOneParameters(), request.getParameterMap())) {
            throw new InvalidParameterException("Request contains invalid query string parameters.");
        }
        Set<String> fields = RequestUtils.getFilteredFieldsFromRequest(request);
        Set<String> exclude = RequestUtils.getExcludedFieldsFromRequest(request);
        Model entity = (Model)this.repository.findOne(id);
        if (entity == null) {
            throw new ResourceNotFoundException();
        }
        ResponseEnvelope envelope = null;
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            FilterableResource resource = (FilterableResource)this.assembler.toResource((Object)entity);
            envelope = new ResponseEnvelope((Object)resource, fields, exclude);
        } else {
            envelope = new ResponseEnvelope(entity, fields, exclude);
        }
        return new ResponseEntity(envelope, HttpStatus.OK);
    }

    @Override
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Invalid parameters", response=RestError.class), @ApiResponse(code=401, message="Unauthorized", response=RestError.class)})
    @RequestMapping(value={"/distinct"}, method={RequestMethod.GET}, produces={"application/hal+json", "application/json", "application/hal+xml", "application/xml", "text/plain"})
    public ResponseEntity<ResponseEnvelope<Object>> findDistinct(@ApiParam(name="field", value="Model field name.") @RequestParam String field, HttpServletRequest request) {
        List<QueryCriteria> queryCriterias = RequestUtils.getQueryCriteriaFromFindDistinctRequest(this.model, request);
        List distinct = (List)this.repository.distinct(field, queryCriterias);
        ResponseEnvelope envelope = null;
        if (ApiMediaTypes.isHalMediaType(request.getHeader("Accept"))) {
            Link selfLink = new Link(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.getClass()).slash((Object)"distinct")).toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""), "self");
            Resources resources = new Resources((Iterable)distinct, new Link[0]);
            resources.add(selfLink);
            envelope = new ResponseEnvelope(resources);
        } else {
            envelope = new ResponseEnvelope(distinct);
        }
        return new ResponseEntity(envelope, HttpStatus.OK);
    }

    @Override
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="Page number.", defaultValue="0", dataType="int", paramType="query"), @ApiImplicitParam(name="size", value="Number of records per page.", defaultValue="1000", dataType="int", paramType="query"), @ApiImplicitParam(name="sort", value="Sort order field and direction.", dataType="string", paramType="query", example="name,asc"), @ApiImplicitParam(name="fields", value="List of fields to be included in response objects", dataType="string", paramType="query"), @ApiImplicitParam(name="exclude", value="List of fields to be excluded from response objects", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Invalid parameters", response=RestError.class), @ApiResponse(code=401, message="Unauthorized", response=RestError.class), @ApiResponse(code=404, message="Record not found.", response=RestError.class)})
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json", "application/hal+xml", "application/xml", "text/plain"})
    public ResponseEntity<ResponseEnvelope<T>> find(@PageableDefault(size=1000) Pageable pageable, PagedResourcesAssembler<T> pagedResourcesAssembler, HttpServletRequest request) {
        ResponseEnvelope envelope;
        Set<String> fields = RequestUtils.getFilteredFieldsFromRequest(request);
        Set<String> exclude = RequestUtils.getExcludedFieldsFromRequest(request);
        pageable = RequestUtils.remapPageable(pageable, this.model);
        Map parameterMap = request.getParameterMap();
        List<QueryCriteria> criterias = RequestUtils.getQueryCriteriaFromFindRequest(this.model, request);
        String mediaType = request.getHeader("Accept");
        Link selfLink = new Link(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.getClass()).slash((Object)"")).toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""), "self");
        if (parameterMap.containsKey("page") || parameterMap.containsKey("size")) {
            Page page = this.repository.find(criterias, pageable);
            if (ApiMediaTypes.isHalMediaType(mediaType)) {
                PagedResources pagedResources = pagedResourcesAssembler.toResource(page, this.assembler, selfLink);
                envelope = new ResponseEnvelope(pagedResources, fields, exclude);
            } else {
                envelope = new ResponseEnvelope(page, fields, exclude);
            }
        } else {
            Sort sort = pageable.getSort();
            List entities = null;
            entities = sort != null ? (List)this.repository.find(criterias, sort) : (List)this.repository.find(criterias);
            if (ApiMediaTypes.isHalMediaType(mediaType)) {
                List resourceList = this.assembler.toResources((Iterable)entities);
                Resources resources = new Resources((Iterable)resourceList, new Link[0]);
                resources.add(selfLink);
                envelope = new ResponseEnvelope(resources, fields, exclude);
            } else {
                envelope = new ResponseEnvelope(entities, fields, exclude);
            }
        }
        return new ResponseEntity(envelope, HttpStatus.OK);
    }

    @Override
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    @RequestMapping(value={"", "/**"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> head(HttpServletRequest request) {
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.OPTIONS})
    public ResponseEntity<?> options(HttpServletRequest request) {
        return new ResponseEntity(HttpStatus.OK);
    }

    public RepositoryOperations<T, ID> getRepository() {
        return this.repository;
    }

    public ResourceAssemblerSupport<T, FilterableResource> getAssembler() {
        return this.assembler;
    }

    public Class<T> getModel() {
        return this.model;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

