/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.controller;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.oncoblocks.centromere.core.model.Alias;
import org.oncoblocks.centromere.core.model.Aliases;
import org.oncoblocks.centromere.core.model.ForeignKey;
import org.oncoblocks.centromere.core.model.Ignored;
import org.oncoblocks.centromere.core.model.Model;
import org.oncoblocks.centromere.core.repository.Evaluation;
import org.oncoblocks.centromere.core.repository.QueryCriteria;
import org.oncoblocks.centromere.core.repository.QueryParameterDescriptor;
import org.oncoblocks.centromere.web.exceptions.InvalidParameterException;
import org.oncoblocks.centromere.web.exceptions.ParameterMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class RequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);
    private static final List<String> FIELD_FILTER_PARAMETERS = Arrays.asList("fields", "exclude");
    private static final List<String> DISTINCT_PARAMETERS = Arrays.asList("field");
    private static final List<String> PAGINATION_PARAMETERS = Arrays.asList("page", "size", "sort");

    public static List<String> findAllParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(FIELD_FILTER_PARAMETERS);
        params.addAll(PAGINATION_PARAMETERS);
        return params;
    }

    public static List<String> findOneParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(FIELD_FILTER_PARAMETERS);
        return params;
    }

    public static List<String> findDistinctParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(FIELD_FILTER_PARAMETERS);
        params.addAll(DISTINCT_PARAMETERS);
        return params;
    }

    public static List<QueryCriteria> getQueryCriteriaFromFindRequest(Class<? extends Model<?>> model, HttpServletRequest request) {
        logger.info(String.format("Generating QueryCriteria for 'find' request parameters: model=%s params=%s", model.getName(), request.getQueryString()));
        List<String> defaultParameters = RequestUtils.findAllParameters();
        Map<String, QueryParameterDescriptor> paramMap = RequestUtils.getAvailableQueryParameters(model);
        List<QueryCriteria> criteriaList = RequestUtils.getQueryCriteriaFromRequest(paramMap, defaultParameters, request);
        logger.info(String.format("Generated QueryCriteria for request: %s", criteriaList.toString()));
        return criteriaList;
    }

    public static List<QueryCriteria> getQueryCriteriaFromFindOneRequest(Class<? extends Model<?>> model, HttpServletRequest request) {
        logger.info(String.format("Generating QueryCriteria for 'findOne' request parameters: model=%s params=%s", model.getName(), request.getQueryString()));
        List<String> defaultParameters = RequestUtils.findOneParameters();
        Map<String, QueryParameterDescriptor> paramMap = RequestUtils.getAvailableQueryParameters(model);
        List<QueryCriteria> criteriaList = RequestUtils.getQueryCriteriaFromRequest(paramMap, defaultParameters, request);
        logger.info(String.format("Generated QueryCriteria for request: %s", criteriaList.toString()));
        return criteriaList;
    }

    public static List<QueryCriteria> getQueryCriteriaFromFindDistinctRequest(Class<? extends Model<?>> model, HttpServletRequest request) {
        logger.info(String.format("Generating QueryCriteria for 'findDistinct' request parameters: model=%s params=%s", model.getName(), request.getQueryString()));
        List<String> defaultParameters = RequestUtils.findDistinctParameters();
        Map<String, QueryParameterDescriptor> paramMap = RequestUtils.getAvailableQueryParameters(model);
        List<QueryCriteria> criteriaList = RequestUtils.getQueryCriteriaFromRequest(paramMap, defaultParameters, request);
        logger.info(String.format("Generated QueryCriteria for request: %s", criteriaList.toString()));
        return criteriaList;
    }

    public static boolean requestContainsNonDefaultParameters(Collection<String> defaultParameters, Map<String, String[]> requestParams) {
        for (String param : requestParams.keySet()) {
            if (defaultParameters.contains(param)) continue;
            return true;
        }
        return false;
    }

    public static List<QueryCriteria> getQueryCriteriaFromRequest(Map<String, QueryParameterDescriptor> paramMap, List<String> defaultParameters, HttpServletRequest request) {
        ArrayList<QueryCriteria> criteriaList = new ArrayList<QueryCriteria>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String paramName = (String)entry.getKey();
            Object[] paramValue = ((String[])entry.getValue())[0].split(",");
            if (defaultParameters.contains(paramName)) continue;
            if (paramMap.containsKey(paramName)) {
                QueryParameterDescriptor descriptor = paramMap.get(paramName);
                QueryCriteria criteria = RequestUtils.createCriteriaFromRequestParameter(descriptor.getFieldName(), paramValue, descriptor.getType(), descriptor.getEvaluation());
                criteriaList.add(criteria);
                continue;
            }
            logger.warn(String.format("Unable to map request parameter to available model parameters: %s", paramName));
            throw new InvalidParameterException("Invalid request parameter: " + paramName);
        }
        return criteriaList;
    }

    public static Map<String, QueryParameterDescriptor> getAvailableQueryParameters(Class<? extends Model<?>> model, boolean recursive) {
        HashMap<String, QueryParameterDescriptor> paramMap = new HashMap<String, QueryParameterDescriptor>();
        for (Field field : model.getDeclaredFields()) {
            String fieldName = field.getName();
            Class type = field.getType();
            if (Collection.class.isAssignableFrom(field.getType())) {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                type = (Class)parameterizedType.getActualTypeArguments()[0];
            }
            if (field.isAnnotationPresent(Ignored.class)) continue;
            paramMap.put(fieldName, new QueryParameterDescriptor(fieldName, fieldName, type, Evaluation.EQUALS));
            if (field.isAnnotationPresent(ForeignKey.class)) {
                if (!recursive) continue;
                ForeignKey foreignKey = field.getAnnotation(ForeignKey.class);
                String relField = !"".equals(foreignKey.rel()) ? foreignKey.rel() : fieldName;
                Map<String, QueryParameterDescriptor> foreignModelMap = RequestUtils.getAvailableQueryParameters(foreignKey.model(), false);
                for (QueryParameterDescriptor descriptor : foreignModelMap.values()) {
                    String newParamName = relField + "." + descriptor.getParamName();
                    descriptor.setParamName(newParamName);
                    paramMap.put(newParamName, descriptor);
                }
            }
            if (field.isAnnotationPresent(Aliases.class)) {
                Aliases aliases = field.getAnnotation(Aliases.class);
                for (Alias alias : aliases.value()) {
                    paramMap.put(alias.value(), new QueryParameterDescriptor(alias.value(), alias.fieldName().equals("") ? fieldName : alias.fieldName(), type, alias.evaluation()));
                }
                continue;
            }
            if (!field.isAnnotationPresent(Alias.class)) continue;
            Alias alias = field.getAnnotation(Alias.class);
            paramMap.put(alias.value(), new QueryParameterDescriptor(alias.value(), alias.fieldName().equals("") ? fieldName : alias.fieldName(), type, alias.evaluation()));
        }
        return paramMap;
    }

    public static Map<String, QueryParameterDescriptor> getAvailableQueryParameters(Class<? extends Model<?>> model) {
        return RequestUtils.getAvailableQueryParameters(model, true);
    }

    public static QueryCriteria createCriteriaFromRequestParameter(String param, Object[] values, Class<?> type, Evaluation evaluation) {
        logger.debug(String.format("Generating QueryCriteria object for query string parameter: param=%s values=%s type=%s eval=%s", param, values.toString(), type.getName(), evaluation.toString()));
        if (evaluation.equals((Object)Evaluation.EQUALS) && values.length > 1) {
            evaluation = Evaluation.IN;
        }
        switch (evaluation) {
            case EQUALS: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.EQUALS);
            }
            case NOT_EQUALS: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.NOT_EQUALS);
            }
            case IN: {
                return new QueryCriteria(param, RequestUtils.convertParameterArray(values, type), Evaluation.IN);
            }
            case NOT_IN: {
                return new QueryCriteria(param, Arrays.asList(values), Evaluation.NOT_IN);
            }
            case IS_NULL: {
                return new QueryCriteria(param, (Object)true, Evaluation.IS_NULL);
            }
            case NOT_NULL: {
                return new QueryCriteria(param, (Object)true, Evaluation.NOT_NULL);
            }
            case IS_TRUE: {
                return new QueryCriteria(param, (Object)true, Evaluation.IS_TRUE);
            }
            case IS_FALSE: {
                return new QueryCriteria(param, (Object)true, Evaluation.IS_FALSE);
            }
            case GREATER_THAN: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.GREATER_THAN);
            }
            case GREATER_THAN_EQUALS: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.GREATER_THAN_EQUALS);
            }
            case LESS_THAN: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.LESS_THAN);
            }
            case LESS_THAN_EQUALS: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.LESS_THAN_EQUALS);
            }
            case BETWEEN: {
                return new QueryCriteria(param, Arrays.asList(RequestUtils.convertParameter(values[0], type), RequestUtils.convertParameter(values[1], type)), Evaluation.BETWEEN);
            }
            case OUTSIDE: {
                return new QueryCriteria(param, Arrays.asList(RequestUtils.convertParameter(values[0], type), RequestUtils.convertParameter(values[1], type)), Evaluation.OUTSIDE);
            }
            case BETWEEN_INCLUSIVE: {
                return new QueryCriteria(param, Arrays.asList(RequestUtils.convertParameter(values[0], type), RequestUtils.convertParameter(values[1], type)), Evaluation.BETWEEN_INCLUSIVE);
            }
            case OUTSIDE_INCLUSIVE: {
                return new QueryCriteria(param, Arrays.asList(RequestUtils.convertParameter(values[0], type), RequestUtils.convertParameter(values[1], type)), Evaluation.OUTSIDE_INCLUSIVE);
            }
            case STARTS_WITH: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.STARTS_WITH);
            }
            case ENDS_WITH: {
                return new QueryCriteria(param, RequestUtils.convertParameter(values[0], type), Evaluation.ENDS_WITH);
            }
        }
        return null;
    }

    public static Object convertParameter(Object param, Class<?> type, ConversionService conversionService) {
        logger.debug(String.format("Attempting to convert parameter: from=%s to=%s", param.getClass().getName(), type.getName()));
        if (conversionService.canConvert(param.getClass(), type)) {
            try {
                return conversionService.convert(param, type);
            }
            catch (ConversionFailedException e) {
                e.printStackTrace();
                throw new ParameterMappingException("Unable to convert parameter string to " + type.getName());
            }
        }
        return param;
    }

    public static Object convertParameter(Object param, Class<?> type) {
        DefaultConversionService conversionService = new DefaultConversionService();
        return RequestUtils.convertParameter(param, type, (ConversionService)conversionService);
    }

    public static List<Object> convertParameterArray(Object[] params, Class<?> type) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object param : params) {
            objects.add(RequestUtils.convertParameter(param, type));
        }
        return objects;
    }

    public static Set<String> getFilteredFieldsFromRequest(HttpServletRequest request) {
        HashSet<String> fields = null;
        if (request.getParameterMap().containsKey("fields")) {
            String[] params;
            fields = new HashSet<String>();
            for (String field : params = request.getParameter("fields").split(",")) {
                fields.add(field.trim());
            }
        }
        return fields;
    }

    public static Set<String> getExcludedFieldsFromRequest(HttpServletRequest request) {
        HashSet<String> exclude = null;
        if (request.getParameterMap().containsKey("exclude")) {
            String[] params;
            exclude = new HashSet<String>();
            for (String field : params = request.getParameter("exclude").split(",")) {
                exclude.add(field.trim());
            }
        }
        return exclude;
    }

    public static Pageable remapPageable(Pageable pageable, Class<? extends Model<?>> model) {
        logger.debug("Attempting to remap Pageable parameter names.");
        Sort sort = null;
        if (pageable.getSort() != null) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (Sort.Order order : pageable.getSort()) {
                orders.add(new Sort.Order(order.getDirection(), RequestUtils.remapParameterName(order.getProperty(), model)));
            }
            sort = new Sort(orders);
        }
        return new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), sort);
    }

    public static String remapParameterName(String param, Class<? extends Model<?>> model) {
        logger.debug(String.format("Attempting to remap query string parameter: %s", param));
        for (Field field : model.getDeclaredFields()) {
            Alias alias;
            String fieldName = field.getName();
            if (field.isAnnotationPresent(Aliases.class)) {
                Aliases aliases = field.getAnnotation(Aliases.class);
                for (Alias alias2 : aliases.value()) {
                    if (!alias2.value().equals(param)) continue;
                    return fieldName;
                }
                continue;
            }
            if (!field.isAnnotationPresent(Alias.class) || !(alias = field.getAnnotation(Alias.class)).value().equals(param)) continue;
            return fieldName;
        }
        logger.debug(String.format("Parameter remapped to: %s", param));
        return param;
    }
}

