/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.oncoblocks.centromere.web.security.TokenOperations;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.GenericFilterBean;

public class AuthenticationTokenProcessingFilter
extends GenericFilterBean {
    private final TokenOperations tokenOperations;
    private final UserDetailsService userDetailsService;

    public AuthenticationTokenProcessingFilter(TokenOperations tokenOperations, UserDetailsService userDetailsService) {
        this.tokenOperations = tokenOperations;
        this.userDetailsService = userDetailsService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserDetails userDetails;
        String username;
        if (!(request instanceof HttpServletRequest)) {
            throw new RuntimeException("Expecting an HTTP request.");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String authToken = httpRequest.getHeader("X-Auth-Token");
        if (authToken == null) {
            authToken = httpRequest.getParameter("token");
        }
        if ((username = this.tokenOperations.getUserNameFromToken(authToken)) != null && this.tokenOperations.validateToken(authToken, userDetails = this.userDetailsService.loadUserByUsername(username))) {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(httpRequest));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        chain.doFilter(request, response);
    }
}

