/*
 * Decompiled with CFR 0.152.
 */
package org.oncoblocks.centromere.web.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;
import org.oncoblocks.centromere.web.controller.ResponseEnvelope;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class FilteringJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private boolean prefixJson = false;

    public void setPrefixJson(boolean prefixJson) {
        this.prefixJson = prefixJson;
        super.setPrefixJson(prefixJson);
    }

    protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        ObjectMapper objectMapper = this.getObjectMapper();
        JsonGenerator jsonGenerator = objectMapper.getFactory().createGenerator(outputMessage.getBody());
        try {
            if (this.prefixJson) {
                jsonGenerator.writeRaw(")]}', ");
            }
            if (object instanceof ResponseEnvelope) {
                ResponseEnvelope envelope = (ResponseEnvelope)object;
                Object entity = envelope.getEntity();
                Set<String> fieldSet = envelope.getFieldSet();
                Set<String> exclude = envelope.getExclude();
                SimpleFilterProvider filters = null;
                if (fieldSet != null && !fieldSet.isEmpty()) {
                    if (entity instanceof ResourceSupport) {
                        fieldSet.add("content");
                    }
                    filters = new SimpleFilterProvider().addFilter("fieldFilter", SimpleBeanPropertyFilter.filterOutAllExcept(fieldSet)).setFailOnUnknownId(false);
                } else {
                    filters = exclude != null && !exclude.isEmpty() ? new SimpleFilterProvider().addFilter("fieldFilter", SimpleBeanPropertyFilter.serializeAllExcept(exclude)).setFailOnUnknownId(false) : new SimpleFilterProvider().addFilter("fieldFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0])).setFailOnUnknownId(false);
                }
                objectMapper.setFilterProvider((FilterProvider)filters);
                objectMapper.writeValue(jsonGenerator, entity);
            } else if (object == null) {
                jsonGenerator.writeNull();
            } else {
                SimpleFilterProvider filters = new SimpleFilterProvider().setFailOnUnknownId(false);
                objectMapper.setFilterProvider((FilterProvider)filters);
                objectMapper.writeValue(jsonGenerator, object);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new HttpMessageNotWritableException("Could not write JSON: " + e.getMessage());
        }
    }
}

