/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.agency_metadata.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.onebusaway.agency_metadata.model.AgencyMetadata;
import org.onebusaway.agency_metadata.service.AgencyMetadataDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AgencyMetadataDaoImpl
implements AgencyMetadataDao {
    protected static Logger _log = LoggerFactory.getLogger(AgencyMetadataDaoImpl.class);
    private SessionFactory _sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void saveOrUpdate(AgencyMetadata metadata) {
        this.getSession().saveOrUpdate((Object)metadata);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void saveOrUpdate(AgencyMetadata ... array) {
        for (int i = 0; i < array.length; ++i) {
            this.getSession().saveOrUpdate((Object)array[i]);
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void delete(long id) {
        Query query = this.getSession().createQuery("from AgencyMetadata where id=:id");
        query.setParameter("id", (Object)id);
        List models = query.list();
        this.getSession().delete(models.get(0));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void removeAgencyMetadata(String agencyMetadataId) {
        Query query = this.getSession().createQuery("from AgencyMetadata where id=:id");
        query.setParameter("id", (Object)Long.valueOf(agencyMetadataId));
        List models = query.list();
        this.getSession().delete(models.get(0));
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAllAgencyMetadata() {
        return this.getSession().createQuery("from AgencyMetadata").list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAgencyMetadataForId(String id) {
        AgencyMetadata model = (AgencyMetadata)this.getSession().get(AgencyMetadata.class, (Serializable)Long.valueOf(id));
        ArrayList<AgencyMetadata> metadata = new ArrayList<AgencyMetadata>();
        metadata.add(model);
        return metadata;
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForGtfsId(String gtfsId) {
        Query query = this.getSession().createQuery("from AgencyMetadata where gtfsId=:gtfsId");
        query.setParameter("gtfsId", (Object)gtfsId);
        return query.list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAgencyMetadataForName(String name) {
        Query query = this.getSession().createQuery("from AgencyMetadata where name=:name");
        query.setParameter("name", (Object)name);
        return query.list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAgencyMetadataForShortName(String shortName) {
        Query query = this.getSession().createQuery("from AgencyMetadata where shortName=:shortName");
        query.setParameter("shortName", (Object)shortName);
        return query.list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAgencyMetadataForLegacyId(String legacyId) {
        Query query = this.getSession().createQuery("from AgencyMetadata where legacyId=:legacyId");
        query.setParameter("legacyId", (Object)legacyId);
        return query.list();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AgencyMetadata> getAgencyMetadataForNtdId(String ntdId) {
        Query query = this.getSession().createQuery("from AgencyMetadata where ntdId=:ntdId");
        query.setParameter("ntdId", (Object)ntdId);
        return query.list();
    }

    private Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }
}

