/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.agency_metadata.service;

import java.util.List;
import org.onebusaway.agency_metadata.model.AgencyMetadata;
import org.onebusaway.agency_metadata.service.AgencyMetadataDao;
import org.onebusaway.agency_metadata.service.AgencyMetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgencyMetadataServiceImpl
implements AgencyMetadataService {
    protected static Logger _log = LoggerFactory.getLogger(AgencyMetadataServiceImpl.class);
    private static final String POINT = " *\\d+\\.\\d+ -\\d+\\.\\d+,";
    private static final String LASTPOINT = " *\\d+\\.\\d+ -\\d+\\.\\d+";
    private static final String POLYGON = "^POLYGON[ ?]\\(\\( *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+\\)\\)";
    @Autowired
    private AgencyMetadataDao _agencyMetadataDao;

    @Override
    public void createAgencyMetadata(String gtfsId, String name, String shortName, String legacyId, String gtfsFeedUrl, String gtfsRtFeedUrl, String boundingBox, String ntdId, String agencyMessage) {
        if (!this.isValidBoundingBox(boundingBox)) {
            boundingBox = null;
        }
        AgencyMetadata model = new AgencyMetadata();
        model.setId(0L);
        model.setGtfsId(gtfsId);
        model.setName(name);
        model.setShortName(shortName);
        model.setLegacyId(legacyId);
        model.setGtfsFeedUrl(gtfsFeedUrl);
        model.setGtfsRtFeedUrl(gtfsRtFeedUrl);
        model.setBoundingBox(boundingBox);
        model.setNtdId(ntdId);
        model.setAgencyMessage(agencyMessage);
        this._agencyMetadataDao.saveOrUpdate(model);
    }

    @Override
    public void createAgencyMetadata(AgencyMetadata model) {
        model.setId(0L);
        this._agencyMetadataDao.saveOrUpdate(model);
    }

    @Override
    public void updateAgencyMetadata(long id, String gtfsId, String name, String shortName, String legacyId, String gtfsFeedUrl, String gtfsRtFeedUrl, String boundingBox, String ntdId, String agencyMessage) {
        AgencyMetadata model = this.getAgencyMetadataForId(String.valueOf(id)).get(0);
        if (gtfsId != null) {
            model.setGtfsId(gtfsId);
        }
        if (name != null) {
            model.setName(name);
        }
        if (shortName != null) {
            model.setShortName(shortName);
        }
        if (legacyId != null) {
            model.setLegacyId(legacyId);
        }
        if (gtfsFeedUrl != null) {
            model.setGtfsFeedUrl(gtfsFeedUrl);
        }
        if (gtfsRtFeedUrl != null) {
            model.setGtfsRtFeedUrl(gtfsRtFeedUrl);
        }
        if (!this.isValidBoundingBox(boundingBox)) {
            boundingBox = null;
        }
        if (boundingBox != null) {
            model.setBoundingBox(boundingBox);
        }
        if (ntdId != null) {
            model.setNtdId(ntdId);
        }
        if (agencyMessage != null) {
            model.setAgencyMessage(agencyMessage);
        }
        this._agencyMetadataDao.saveOrUpdate(model);
    }

    @Override
    public void updateAgencyMetadata(AgencyMetadata model) {
        this._agencyMetadataDao.saveOrUpdate(model);
    }

    @Override
    public void delete(long id) {
        this._agencyMetadataDao.delete(id);
    }

    @Override
    public void removeAgencyMetadata(String agencyMetadataId) {
        this._agencyMetadataDao.removeAgencyMetadata(agencyMetadataId);
    }

    @Override
    public List<AgencyMetadata> getAllAgencyMetadata() {
        return this._agencyMetadataDao.getAllAgencyMetadata();
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForId(String id) {
        return this._agencyMetadataDao.getAgencyMetadataForId(id);
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForGtfsId(String gtfsId) {
        return this._agencyMetadataDao.getAgencyMetadataForGtfsId(gtfsId);
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForName(String name) {
        return this._agencyMetadataDao.getAgencyMetadataForName(name);
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForShortName(String shortName) {
        return this._agencyMetadataDao.getAgencyMetadataForShortName(shortName);
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForLegacyId(String legacyId) {
        return this._agencyMetadataDao.getAgencyMetadataForLegacyId(legacyId);
    }

    @Override
    public List<AgencyMetadata> getAgencyMetadataForNtdId(String ntdId) {
        return this._agencyMetadataDao.getAgencyMetadataForNtdId(ntdId);
    }

    @Override
    public String getAgencyMetadataMessage(String id) {
        String message = "";
        List<AgencyMetadata> agencyMetadataList = this._agencyMetadataDao.getAgencyMetadataForId(id);
        if (agencyMetadataList != null && agencyMetadataList.size() > 0) {
            message = agencyMetadataList.get(0).getAgencyMessage();
        }
        return message;
    }

    private boolean isValidBoundingBox(String wkt) {
        _log.info("Validating: " + wkt);
        if (wkt == null || wkt.length() == 0) {
            return false;
        }
        if (!wkt.matches(POLYGON)) {
            _log.info("Validation of POLYGON against ^POLYGON[ ?]\\(\\( *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+, *\\d+\\.\\d+ -\\d+\\.\\d+\\)\\) failed");
            return false;
        }
        _log.info("Validation of POLYGON succeeded");
        return true;
    }
}

