/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.alerts.impl.AffectsKeyFactory;
import org.onebusaway.alerts.impl.RouteDirectionAndStopCallRef;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.gtfs.model.AgencyAndId;

class AffectsRouteDirectionAndStopCallKeyFactory
implements AffectsKeyFactory<RouteDirectionAndStopCallRef> {
    public static final AffectsRouteDirectionAndStopCallKeyFactory INSTANCE = new AffectsRouteDirectionAndStopCallKeyFactory();

    AffectsRouteDirectionAndStopCallKeyFactory() {
    }

    @Override
    public Set<RouteDirectionAndStopCallRef> getKeysForAffects(ServiceAlertRecord serviceAlert) {
        HashSet<RouteDirectionAndStopCallRef> keys = new HashSet<RouteDirectionAndStopCallRef>();
        for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
            if (affects.getRouteId() == null || affects.getDirectionId() == null || affects.getStopId() == null || affects.getTripId() != null) continue;
            AgencyAndId routeId = ServiceAlertLibrary.agencyAndIdAndId(serviceAlert.getAgencyId(), affects.getRouteId());
            String directionId = affects.getDirectionId();
            AgencyAndId stopId = ServiceAlertLibrary.agencyAndIdAndId(serviceAlert.getAgencyId(), affects.getStopId());
            RouteDirectionAndStopCallRef ref = new RouteDirectionAndStopCallRef(routeId, directionId, stopId);
            keys.add(ref);
        }
        return keys;
    }
}

