/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.alerts.impl.AffectsAgencyKeyFactory;
import org.onebusaway.alerts.impl.AffectsKeyFactory;
import org.onebusaway.alerts.impl.AffectsRouteAndDirectionKeyFactory;
import org.onebusaway.alerts.impl.AffectsRouteAndStopKeyFactory;
import org.onebusaway.alerts.impl.AffectsRouteDirectionAndStopCallKeyFactory;
import org.onebusaway.alerts.impl.AffectsRouteKeyFactory;
import org.onebusaway.alerts.impl.AffectsServiceAlertAgencyKeyFactory;
import org.onebusaway.alerts.impl.AffectsStopKeyFactory;
import org.onebusaway.alerts.impl.AffectsTripAndStopKeyFactory;
import org.onebusaway.alerts.impl.AffectsTripKeyFactory;
import org.onebusaway.alerts.impl.RouteAndDirectionRef;
import org.onebusaway.alerts.impl.RouteAndStopCallRef;
import org.onebusaway.alerts.impl.RouteDirectionAndStopCallRef;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsCache;
import org.onebusaway.alerts.impl.ServiceAlertsPersistence;
import org.onebusaway.alerts.impl.TripAndStopCallRef;
import org.onebusaway.alerts.service.ServiceAlertsService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceAlertsServiceImpl
implements ServiceAlertsService {
    private static Logger _log = LoggerFactory.getLogger(ServiceAlertsServiceImpl.class);
    private ServiceAlertsCache _cache;
    private ServiceAlertsPersistence _persister;

    @Autowired
    public void setServiceAlertsCache(ServiceAlertsCache cache) {
        this._cache = cache;
    }

    public ServiceAlertsCache getServiceAlertsCache() {
        return this._cache;
    }

    @Autowired
    public void setServiceAlertsPersistence(ServiceAlertsPersistence persister) {
        this._persister = persister;
    }

    public ServiceAlertsPersistence getServiceAlertsPeristence() {
        return this._persister;
    }

    @PostConstruct
    public void start() {
        try {
            this.loadServiceAlerts();
        }
        catch (Throwable t) {
            _log.error("issue loading service alerts: ", t);
        }
    }

    @PreDestroy
    public void stop() {
        _log.info("Stopping ServiceAlertsService");
    }

    @Override
    public synchronized ServiceAlertRecord createOrUpdateServiceAlert(ServiceAlertRecord serviceAlertRecord) {
        if (this._persister.needsSync()) {
            this.loadServiceAlerts();
        }
        if (serviceAlertRecord.getServiceAlertId() == null) {
            UUID uuid = UUID.randomUUID();
            serviceAlertRecord.setServiceAlertId(uuid.toString());
        }
        long lastModified = SystemTime.currentTimeMillis();
        if (serviceAlertRecord.getCreationTime() < 1L) {
            serviceAlertRecord.setCreationTime(lastModified);
        }
        this.updateReferences(serviceAlertRecord);
        this.saveDBServiceAlerts(serviceAlertRecord, (Long)lastModified);
        return serviceAlertRecord;
    }

    @Override
    public synchronized List<ServiceAlertRecord> createOrUpdateServiceAlerts(String agencyId, List<ServiceAlertRecord> records) {
        if (this._persister.needsSync()) {
            this.loadServiceAlerts();
        }
        long lastModified = SystemTime.currentTimeMillis();
        for (ServiceAlertRecord serviceAlertRecord : records) {
            if (serviceAlertRecord.getServiceAlertId() == null) {
                UUID uuid = UUID.randomUUID();
                serviceAlertRecord.setServiceAlertId(uuid.toString());
            }
            if (serviceAlertRecord.getCreationTime() < 1L) {
                serviceAlertRecord.setCreationTime(lastModified);
            }
            this.updateReferences(serviceAlertRecord);
        }
        this.saveDBServiceAlerts(records, (Long)lastModified);
        return records;
    }

    @Override
    public synchronized ServiceAlertRecord copyServiceAlert(ServiceAlertRecord serviceAlertRecord) {
        if (this._persister.needsSync()) {
            this.loadServiceAlerts();
        }
        UUID uuid = UUID.randomUUID();
        serviceAlertRecord.setServiceAlertId(uuid.toString());
        long lastModified = SystemTime.currentTimeMillis();
        serviceAlertRecord.setCreationTime(lastModified);
        serviceAlertRecord.setCopy(Boolean.TRUE);
        this.updateReferences(serviceAlertRecord);
        this.saveDBServiceAlerts(serviceAlertRecord, (Long)lastModified);
        return serviceAlertRecord;
    }

    @Override
    public synchronized void removeServiceAlert(AgencyAndId serviceAlertId) {
        this.removeServiceAlerts(Arrays.asList(serviceAlertId));
    }

    @Override
    public synchronized void removeServiceAlerts(List<AgencyAndId> serviceAlertIds) {
        if (this._persister.needsSync()) {
            this.loadServiceAlerts();
        }
        for (AgencyAndId serviceAlertId : serviceAlertIds) {
            ServiceAlertRecord existingServiceAlert = this._cache.removeServiceAlert(serviceAlertId);
            if (existingServiceAlert != null) {
                this.updateReferences(existingServiceAlert, null);
            }
            ServiceAlertRecord existingServiceAlertRecord = this.getServiceAlertRecordByAlertId(serviceAlertId.getAgencyId(), serviceAlertId.getId());
            _log.debug("deleting service alert " + serviceAlertId.getId());
            if (existingServiceAlertRecord == null) continue;
            this._persister.delete(existingServiceAlertRecord);
        }
    }

    @Override
    public synchronized void removeAllServiceAlertsForFederatedAgencyId(String agencyId) {
        Set<AgencyAndId> ids = this._cache.getServiceAlertIdsByServiceAlertAgencyId().get(agencyId);
        if (ids != null) {
            this.removeServiceAlerts(new ArrayList<AgencyAndId>(ids));
        }
    }

    @Override
    public ServiceAlertRecord getServiceAlertForId(AgencyAndId serviceAlertId) {
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        return this._cache.getServiceAlerts().get(serviceAlertId);
    }

    @Override
    public List<ServiceAlertRecord> getAllServiceAlerts() {
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        return new ArrayList<ServiceAlertRecord>(this._cache.getServiceAlerts().values());
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForFederatedAgencyId(String agencyId) {
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        Set<AgencyAndId> serviceAlertIds = this._cache.getServiceAlertIdsByServiceAlertAgencyId().get(agencyId);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForAgencyId(long time, String agencyId) {
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByAgencyId(), agencyId, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForStopId(long time, AgencyAndId stopId) {
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByAgencyId(), stopId.getAgencyId(), serviceAlertIds);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByStopId(), stopId, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForRouteId(long time, AgencyAndId routeId) {
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteId(), routeId, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForRouteAndStopId(long time, AgencyAndId routeId, AgencyAndId stopId) {
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        RouteAndStopCallRef routeAndStopCallRef = new RouteAndStopCallRef(routeId, stopId);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteAndStop(), routeAndStopCallRef, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForRouteAndDirection(long time, AgencyAndId routeId, AgencyAndId tripId, String directionId) {
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        RouteAndDirectionRef lineAndDirectionRef = new RouteAndDirectionRef(routeId, directionId);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByAgencyId(), routeId.getAgencyId(), serviceAlertIds);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteId(), routeId, serviceAlertIds);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteAndDirectionId(), lineAndDirectionRef, serviceAlertIds);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByTripId(), tripId, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlertsForTripAndStopId(long time, AgencyAndId tripId, AgencyAndId stopId) {
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByTripId(), tripId, serviceAlertIds);
        TripAndStopCallRef tripAndStopCallRef = new TripAndStopCallRef(tripId, stopId);
        this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByTripAndStopId(), tripAndStopCallRef, serviceAlertIds);
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, time);
    }

    @Override
    public List<ServiceAlertRecord> getServiceAlerts(SituationQueryBean query) {
        HashSet<AgencyAndId> serviceAlertIds = new HashSet<AgencyAndId>();
        if (this._persister.cachedNeedsSync()) {
            this.loadServiceAlerts();
        }
        block10: for (SituationQueryBean.AffectsBean affects : query.getAffects()) {
            AgencyAndId routeId = AgencyAndId.convertFromString((String)affects.getRouteId());
            AgencyAndId tripId = AgencyAndId.convertFromString((String)affects.getTripId());
            AgencyAndId stopId = AgencyAndId.convertFromString((String)affects.getStopId());
            AffectsType type = this.getAffectsType(affects.getAgencyId(), affects.getRouteId(), affects.getDirectionId(), affects.getTripId(), affects.getStopId());
            switch (type) {
                case AGENCY: {
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByAgencyId(), affects.getAgencyId(), serviceAlertIds);
                    continue block10;
                }
                case ROUTE: {
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteId(), routeId, serviceAlertIds);
                    continue block10;
                }
                case TRIP: {
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByTripId(), tripId, serviceAlertIds);
                    continue block10;
                }
                case STOP: {
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByStopId(), stopId, serviceAlertIds);
                    continue block10;
                }
                case ROUTE_DIRECTION: {
                    RouteAndDirectionRef routeAndDirectionRef = new RouteAndDirectionRef(routeId, affects.getDirectionId());
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteAndDirectionId(), routeAndDirectionRef, serviceAlertIds);
                    continue block10;
                }
                case ROUTE_DIRECTION_STOP: {
                    Object ref = new RouteDirectionAndStopCallRef(routeId, affects.getDirectionId(), stopId);
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteDirectionAndStopCall(), ref, serviceAlertIds);
                    continue block10;
                }
                case ROUTE_STOP: {
                    RouteAndStopCallRef routeAndStopRef = new RouteAndStopCallRef(routeId, stopId);
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByRouteAndStop(), routeAndStopRef, serviceAlertIds);
                    continue block10;
                }
                case TRIP_STOP: {
                    Object ref = new TripAndStopCallRef(tripId, stopId);
                    this.getServiceAlertIdsForKey(this._cache.getServiceAlertIdsByTripAndStopId(), ref, serviceAlertIds);
                    continue block10;
                }
            }
            throw new RuntimeException("Unhandled type " + type);
        }
        List<ServiceAlertRecord> alerts = this.getServiceAlertIdsAsObjects(serviceAlertIds, query.getTime());
        return alerts;
    }

    private void updateReferences(ServiceAlertRecord serviceAlert) {
        AgencyAndId id = ServiceAlertLibrary.agencyAndId(serviceAlert.getAgencyId(), serviceAlert.getServiceAlertId());
        ServiceAlertRecord existingServiceAlert = this._cache.putServiceAlert(id, serviceAlert);
        this.updateReferences(existingServiceAlert, serviceAlert);
    }

    private void updateReferences(ServiceAlertRecord existingServiceAlert, ServiceAlertRecord serviceAlert) {
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByServiceAlertAgencyId(), AffectsServiceAlertAgencyKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByAgencyId(), AffectsAgencyKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByStopId(), AffectsStopKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByRouteId(), AffectsRouteKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByRouteAndDirectionId(), AffectsRouteAndDirectionKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByRouteAndStop(), AffectsRouteAndStopKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByRouteDirectionAndStopCall(), AffectsRouteDirectionAndStopCallKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByTripId(), AffectsTripKeyFactory.INSTANCE);
        this.updateReferences(existingServiceAlert, serviceAlert, this._cache.getServiceAlertIdsByTripAndStopId(), AffectsTripAndStopKeyFactory.INSTANCE);
    }

    private <T> void updateReferences(ServiceAlertRecord existingServiceAlert, ServiceAlertRecord serviceAlert, Map<T, Set<AgencyAndId>> map, AffectsKeyFactory<T> affectsKeyFactory) {
        Set<AgencyAndId> ids;
        AgencyAndId id;
        Set existingEffects = Collections.emptySet();
        if (existingServiceAlert != null) {
            existingEffects = affectsKeyFactory.getKeysForAffects(existingServiceAlert);
        }
        Set newEffects = Collections.emptySet();
        if (serviceAlert != null) {
            newEffects = affectsKeyFactory.getKeysForAffects(serviceAlert);
        }
        for (Object existingEffect : existingEffects) {
            if (newEffects.contains(existingEffect)) continue;
            id = ServiceAlertLibrary.agencyAndId(existingServiceAlert.getAgencyId(), existingServiceAlert.getServiceAlertId());
            ids = map.get(existingEffect);
            ids.remove(id);
            if (!ids.isEmpty()) continue;
            map.remove(existingEffect);
        }
        for (Object newEffect : newEffects) {
            if (existingEffects.contains(newEffect)) continue;
            id = ServiceAlertLibrary.agencyAndId(serviceAlert.getAgencyId(), serviceAlert.getServiceAlertId());
            ids = map.get(newEffect);
            if (ids == null) {
                ids = new HashSet<AgencyAndId>();
                map.put(newEffect, ids);
            }
            ids.add(id);
        }
    }

    private synchronized <T> void getServiceAlertIdsForKey(Map<T, Set<AgencyAndId>> serviceAlertIdsByKey, T key, Collection<AgencyAndId> matches) {
        Set<AgencyAndId> ids;
        if (serviceAlertIdsByKey != null && (ids = serviceAlertIdsByKey.get(key)) != null) {
            HashSet<AgencyAndId> copyOfIds = new HashSet<AgencyAndId>(ids);
            matches.addAll(copyOfIds);
        }
    }

    private List<ServiceAlertRecord> getServiceAlertIdsAsObjects(Collection<AgencyAndId> serviceAlertIds) {
        return this.getServiceAlertIdsAsObjects(serviceAlertIds, -1L);
    }

    private List<ServiceAlertRecord> getServiceAlertIdsAsObjects(Collection<AgencyAndId> serviceAlertIds, long time) {
        if (serviceAlertIds == null || serviceAlertIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServiceAlertRecord> serviceAlerts = new ArrayList<ServiceAlertRecord>(serviceAlertIds.size());
        for (AgencyAndId serviceAlertId : serviceAlertIds) {
            ServiceAlertRecord serviceAlert = this._cache.getServiceAlerts().get(serviceAlertId);
            if (serviceAlert == null || !this.filterByTime(serviceAlert, time)) continue;
            serviceAlerts.add(serviceAlert);
        }
        return serviceAlerts;
    }

    private boolean filterByTime(ServiceAlertRecord serviceAlert, long time) {
        if (time == -1L || serviceAlert.getPublicationWindows().size() == 0) {
            return true;
        }
        for (ServiceAlertTimeRange publicationWindow : serviceAlert.getPublicationWindows()) {
            if (publicationWindow.getFromValue() != null && publicationWindow.getFromValue() > time || publicationWindow.getToValue() != null && publicationWindow.getToValue() < time) continue;
            return true;
        }
        return false;
    }

    private AffectsType getAffectsType(String agencyId, String routeId, String directionId, String tripId, String stopId) {
        int count = this.getNonNullCount(agencyId, routeId, directionId, tripId, stopId);
        switch (count) {
            case 0: {
                _log.warn("no arguments specified in affects clause");
                break;
            }
            case 1: {
                if (agencyId != null) {
                    return AffectsType.AGENCY;
                }
                if (routeId != null) {
                    return AffectsType.ROUTE;
                }
                if (tripId != null) {
                    return AffectsType.TRIP;
                }
                if (stopId == null) break;
                return AffectsType.STOP;
            }
            case 2: {
                if (routeId != null && directionId != null) {
                    return AffectsType.ROUTE_DIRECTION;
                }
                if (routeId != null && stopId != null) {
                    return AffectsType.ROUTE_STOP;
                }
                if (tripId == null || stopId == null) break;
                return AffectsType.TRIP_STOP;
            }
            case 3: {
                if (routeId == null || directionId == null || stopId == null) break;
                return AffectsType.ROUTE_DIRECTION_STOP;
            }
        }
        _log.warn("unsupported affects clause: agencyId=" + agencyId + " routeId=" + routeId + " directionId=" + directionId + " tripId=" + tripId + " stopId=" + stopId);
        return AffectsType.UNSUPPORTED;
    }

    private int getNonNullCount(String ... ids) {
        int count = 0;
        for (String id : ids) {
            if (id == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public synchronized void cleanup() {
        this._persister.deleteOrphans();
    }

    @Override
    public synchronized void loadServiceAlerts() {
        this._cache.clear();
        List<ServiceAlertRecord> alerts = this._persister.getAlerts();
        _log.debug("Loaded " + alerts.size() + " service alerts from DB");
        try {
            for (ServiceAlertRecord serviceAlert : alerts) {
                this.updateReferences(serviceAlert);
            }
            _log.info("updateReferences complete with " + this._cache.getServiceAlertIdsByAgencyId().size() + " agency alerts, " + this._cache.getServiceAlertIdsByRouteAndStop().size() + " route and stop alerts, " + this._cache.getServiceAlertIdsByRouteId().size() + " route alerts, and " + this._cache.getServiceAlerts().size() + " distinct alerts");
        }
        catch (Exception ex) {
            _log.error("error loading service alerts from DB ", (Throwable)ex);
        }
    }

    private synchronized void saveDBServiceAlerts(ServiceAlertRecord alert, Long lastModified) {
        if (lastModified == null) {
            lastModified = SystemTime.currentTimeMillis();
        }
        alert.setModifiedTime(lastModified);
        ServiceAlertRecord persistedServiceAlertRecord = this._persister.getServiceAlertRecordByAlertId(alert.getAgencyId(), alert.getServiceAlertId());
        if (persistedServiceAlertRecord != null) {
            alert.setId(persistedServiceAlertRecord.getId());
        }
        _log.debug("Saving Service Alert to DataBase:" + alert.getServiceAlertId());
        this._persister.saveOrUpdate(alert);
    }

    private synchronized void saveDBServiceAlerts(List<ServiceAlertRecord> alerts, Long lastModified) {
        if (lastModified == null) {
            lastModified = SystemTime.currentTimeMillis();
        }
        for (ServiceAlertRecord alert : alerts) {
            alert.setModifiedTime(lastModified);
            ServiceAlertRecord persistedServiceAlertRecord = this._persister.getServiceAlertRecordByAlertId(alert.getAgencyId(), alert.getServiceAlertId());
            if (persistedServiceAlertRecord != null) {
                alert.setId(persistedServiceAlertRecord.getId());
            }
            _log.debug("Saving Service Alert to DataBase:" + alert.getServiceAlertId());
        }
        this._persister.saveOrUpdate(alerts);
    }

    private ServiceAlertRecord getServiceAlertRecordByAlertId(String agencyId, String serviceAlertId) {
        return this._persister.getServiceAlertRecordByAlertId(agencyId, serviceAlertId);
    }

    private static enum AffectsType {
        AGENCY,
        ROUTE,
        ROUTE_DIRECTION,
        ROUTE_STOP,
        ROUTE_DIRECTION_STOP,
        TRIP,
        TRIP_STOP,
        STOP,
        UNSUPPORTED;

    }
}

