/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.alerts.impl.AffectsKeyFactory;
import org.onebusaway.alerts.impl.RouteAndStopCallRef;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.gtfs.model.AgencyAndId;

class AffectsRouteAndStopKeyFactory
implements AffectsKeyFactory<RouteAndStopCallRef> {
    public static final AffectsRouteAndStopKeyFactory INSTANCE = new AffectsRouteAndStopKeyFactory();

    AffectsRouteAndStopKeyFactory() {
    }

    @Override
    public Set<RouteAndStopCallRef> getKeysForAffects(ServiceAlertRecord serviceAlert) {
        HashSet<RouteAndStopCallRef> keys = new HashSet<RouteAndStopCallRef>();
        for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
            if (affects.getRouteId() == null || affects.getStopId() == null || affects.getDirectionId() != null || affects.getTripId() != null) continue;
            AgencyAndId routeId = ServiceAlertLibrary.agencyAndIdAndId(serviceAlert.getAgencyId(), affects.getRouteId());
            AgencyAndId stopId = ServiceAlertLibrary.agencyAndIdAndId(serviceAlert.getAgencyId(), affects.getStopId());
            RouteAndStopCallRef ref = new RouteAndStopCallRef(routeId, stopId);
            keys.add(ref);
        }
        return keys;
    }
}

