/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.alerts.impl.AffectsKeyFactory;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.alerts.impl.TripAndStopCallRef;
import org.onebusaway.gtfs.model.AgencyAndId;

class AffectsStopCallKeyFactory
implements AffectsKeyFactory<TripAndStopCallRef> {
    public static final AffectsStopCallKeyFactory INSTANCE = new AffectsStopCallKeyFactory();

    AffectsStopCallKeyFactory() {
    }

    @Override
    public Set<TripAndStopCallRef> getKeysForAffects(ServiceAlertRecord serviceAlert) {
        HashSet<TripAndStopCallRef> refs = new HashSet<TripAndStopCallRef>();
        for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
            if (affects.getTripId() == null || affects.getStopId() == null || affects.getTripId() != null || affects.getDirectionId() != null || affects.getRouteId() != null) continue;
            AgencyAndId tripId = ServiceAlertLibrary.agencyAndIdAndId(affects.getAgencyId(), affects.getTripId());
            AgencyAndId stopId = ServiceAlertLibrary.agencyAndIdAndId(affects.getAgencyId(), affects.getStopId());
            TripAndStopCallRef ref = new TripAndStopCallRef(tripId, stopId);
            refs.add(ref);
        }
        return refs;
    }
}

