/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import org.onebusaway.alerts.service.ServiceAlerts;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.service_alerts.EEffect;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationAffectsBean;
import org.onebusaway.transit_data.model.service_alerts.SituationConsequenceBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;
import org.onebusaway.util.AgencyAndIdLibrary;

public class ServiceAlertBuilderHelper {
    private static boolean REMOVE_AGENCY_ID = true;

    public static void fillFeedMessage(GtfsRealtime.FeedMessage.Builder feed, ListBean<ServiceAlertBean> alerts, String agencyId, long time) {
        for (ServiceAlertBean serviceAlert : alerts.getList()) {
            GtfsRealtime.FeedEntity.Builder entity = feed.addEntityBuilder();
            if (serviceAlert.getId() != null) {
                entity.setId(serviceAlert.getId());
            } else {
                entity.setId(String.valueOf(feed.getEntityCount()));
            }
            GtfsRealtime.Alert.Builder alert = entity.getAlertBuilder();
            ServiceAlertBuilderHelper.fillTranslations(serviceAlert.getSummaries(), alert.getHeaderTextBuilder());
            ServiceAlertBuilderHelper.fillTranslations(serviceAlert.getDescriptions(), alert.getDescriptionTextBuilder());
            ServiceAlertBuilderHelper.fillTranslations(serviceAlert.getUrls(), alert.getUrlBuilder());
            if (serviceAlert.getActiveWindows() != null) {
                for (TimeRangeBean range : serviceAlert.getActiveWindows()) {
                    GtfsRealtime.TimeRange.Builder timeRange = alert.addActivePeriodBuilder();
                    if (range.getFrom() != 0L) {
                        timeRange.setStart(range.getFrom() / 1000L);
                    }
                    if (range.getTo() == 0L) continue;
                    timeRange.setEnd(range.getTo() / 1000L);
                }
            }
            if (serviceAlert.getAllAffects() == null) continue;
            for (SituationAffectsBean affects : serviceAlert.getAllAffects()) {
                AgencyAndId stopId;
                GtfsRealtime.EntitySelector.Builder entitySelector = alert.addInformedEntityBuilder();
                if (affects.getAgencyId() != null) {
                    entitySelector.setAgencyId(affects.getAgencyId());
                }
                if (affects.getRouteId() != null) {
                    entitySelector.setRouteId(ServiceAlertBuilderHelper.normalizeId(affects.getRouteId()));
                }
                if (affects.getTripId() != null) {
                    GtfsRealtime.TripDescriptor.Builder trip = entitySelector.getTripBuilder();
                    trip.setTripId(ServiceAlertBuilderHelper.normalizeId(affects.getTripId()));
                    entitySelector.setTrip(trip);
                }
                if (affects.getStopId() == null || !(stopId = ServiceAlertBuilderHelper.modifiedStopId(agencyId, affects.getStopId())).getAgencyId().equals(agencyId)) continue;
                entitySelector.setStopId(ServiceAlertBuilderHelper.normalizeId(stopId.toString()));
            }
        }
    }

    public static ServiceAlerts.ServiceAlertsCollection fillServiceAlerts(ListBean<ServiceAlertBean> alerts, String agencyId, long time) {
        ServiceAlerts.ServiceAlertsCollection.Builder feedCollection = ServiceAlerts.ServiceAlertsCollection.newBuilder();
        for (ServiceAlertBean serviceAlert : alerts.getList()) {
            ServiceAlerts.TranslatedString translatedUrl;
            ServiceAlerts.TranslatedString translatedDescription;
            ServiceAlerts.ServiceAlert.Builder feedAlert = ServiceAlerts.ServiceAlert.newBuilder();
            feedAlert.setId(ServiceAlertBuilderHelper.normalizeToId(agencyId, serviceAlert.getId()));
            ServiceAlerts.TranslatedString translatedSummary = ServiceAlertBuilderHelper.toTranslatedString(serviceAlert.getSummaries());
            if (translatedSummary != null) {
                feedAlert.setSummary(translatedSummary);
            }
            if ((translatedDescription = ServiceAlertBuilderHelper.toTranslatedString(serviceAlert.getDescriptions())) != null) {
                feedAlert.setDescription(translatedDescription);
            }
            if ((translatedUrl = ServiceAlertBuilderHelper.toTranslatedString(serviceAlert.getUrls())) != null) {
                feedAlert.setUrl(translatedUrl);
            }
            feedAlert.setCreationTime(serviceAlert.getCreationTime());
            feedAlert.setModifiedTime(serviceAlert.getCreationTime());
            if (serviceAlert.getActiveWindows() != null) {
                for (TimeRangeBean activeWindow : serviceAlert.getActiveWindows()) {
                    feedAlert.addActiveWindow(ServiceAlertBuilderHelper.toTimeRange(activeWindow));
                }
            }
            if (serviceAlert.getAllAffects() != null) {
                for (SituationAffectsBean affect : serviceAlert.getAllAffects()) {
                    feedAlert.addAffects(ServiceAlertBuilderHelper.toAffects(affect));
                }
            }
            if (serviceAlert.getConsequences() != null) {
                for (SituationConsequenceBean bean : serviceAlert.getConsequences()) {
                    feedAlert.addConsequence(ServiceAlertBuilderHelper.toConsequence(bean));
                }
            }
            if (serviceAlert.getPublicationWindows() != null) {
                for (TimeRangeBean trb : serviceAlert.getPublicationWindows()) {
                    feedAlert.addPublicationWindow(ServiceAlertBuilderHelper.toTimeRange(trb));
                }
            }
            if (serviceAlert.getSeverity() != null && ServiceAlertBuilderHelper.toSeverity(serviceAlert.getSeverity()) != null) {
                feedAlert.setSeverity(ServiceAlertBuilderHelper.toSeverity(serviceAlert.getSeverity()));
            }
            if (serviceAlert.getReason() != null && ServiceAlertBuilderHelper.toCause(serviceAlert.getReason()) != null) {
                feedAlert.setCause(ServiceAlertBuilderHelper.toCause(serviceAlert.getReason()));
            }
            if (serviceAlert.getSource() != null) {
                feedAlert.setSource(serviceAlert.getSource());
            }
            feedCollection.addServiceAlerts(feedAlert);
        }
        return feedCollection.build();
    }

    private static ServiceAlerts.ServiceAlert.Cause toCause(String reason) {
        switch (reason) {
            case "OTHER_CAUSE": {
                return ServiceAlerts.ServiceAlert.Cause.OTHER_CAUSE;
            }
            case "TECHNICAL_PROBLEM": {
                return ServiceAlerts.ServiceAlert.Cause.TECHNICAL_PROBLEM;
            }
            case "STRIKE": {
                return ServiceAlerts.ServiceAlert.Cause.STRIKE;
            }
            case "DEMONSTRATION": {
                return ServiceAlerts.ServiceAlert.Cause.DEMONSTRATION;
            }
            case "ACCIDENT": {
                return ServiceAlerts.ServiceAlert.Cause.ACCIDENT;
            }
            case "HOLIDAY": {
                return ServiceAlerts.ServiceAlert.Cause.HOLIDAY;
            }
            case "WEATHER": {
                return ServiceAlerts.ServiceAlert.Cause.WEATHER;
            }
            case "MAINTENANCE": {
                return ServiceAlerts.ServiceAlert.Cause.MAINTENANCE;
            }
            case "CONSTRUCTION": {
                return ServiceAlerts.ServiceAlert.Cause.CONSTRUCTION;
            }
            case "POLICE_ACTIVITY": {
                return ServiceAlerts.ServiceAlert.Cause.POLICE_ACTIVITY;
            }
            case "MEDICAL_EMERGENCY": {
                return ServiceAlerts.ServiceAlert.Cause.MEDICAL_EMERGENCY;
            }
        }
        return ServiceAlerts.ServiceAlert.Cause.UNKNOWN_CAUSE;
    }

    private static ServiceAlerts.ServiceAlert.Severity toSeverity(ESeverity eValue) {
        switch (eValue) {
            case VERY_SLIGHT: {
                return ServiceAlerts.ServiceAlert.Severity.VERY_SLIGHT;
            }
            case SLIGHT: {
                return ServiceAlerts.ServiceAlert.Severity.SLIGHT;
            }
            case NORMAL: {
                return ServiceAlerts.ServiceAlert.Severity.NORMAL;
            }
            case SEVERE: {
                return ServiceAlerts.ServiceAlert.Severity.SEVERE;
            }
            case VERY_SEVERE: {
                return ServiceAlerts.ServiceAlert.Severity.VERY_SEVERE;
            }
        }
        return ServiceAlerts.ServiceAlert.Severity.UNKNOWN;
    }

    private static ServiceAlerts.Consequence toConsequence(SituationConsequenceBean bean) {
        ServiceAlerts.Consequence.Builder builder = ServiceAlerts.Consequence.newBuilder();
        builder.setEffect(ServiceAlertBuilderHelper.toEffect(bean.getEffect()));
        return builder.build();
    }

    private static ServiceAlerts.Consequence.Effect toEffect(EEffect effect) {
        if (effect == null) {
            return ServiceAlerts.Consequence.Effect.UNKNOWN_EFFECT;
        }
        return ServiceAlerts.Consequence.Effect.valueOf((String)effect.toString());
    }

    private static ServiceAlerts.Affects toAffects(SituationAffectsBean affect) {
        ServiceAlerts.Affects.Builder builder = ServiceAlerts.Affects.newBuilder();
        if (affect.getAgencyId() != null) {
            builder.setAgencyId(affect.getAgencyId());
        }
        if (affect.getApplicationId() != null) {
            builder.setApplicationId(affect.getApplicationId());
        }
        if (affect.getRouteId() != null) {
            builder.setRouteId(ServiceAlertBuilderHelper.normalizeToId(affect.getAgencyId(), affect.getRouteId()));
        }
        if (affect.getDirectionId() != null) {
            builder.setDirectionId(affect.getDirectionId());
        }
        if (affect.getStopId() != null) {
            builder.setStopId(ServiceAlertBuilderHelper.normalizeToId(affect.getAgencyId(), affect.getStopId()));
        }
        if (affect.getTripId() != null) {
            builder.setTripId(ServiceAlertBuilderHelper.normalizeToId(affect.getAgencyId(), affect.getTripId()));
        }
        return builder.build();
    }

    private static ServiceAlerts.TimeRange toTimeRange(TimeRangeBean activeWindow) {
        ServiceAlerts.TimeRange.Builder tr = ServiceAlerts.TimeRange.newBuilder();
        tr.setStart(activeWindow.getTo());
        tr.setEnd(activeWindow.getFrom());
        return tr.build();
    }

    private static ServiceAlerts.TranslatedString toTranslatedString(List<NaturalLanguageStringBean> input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        ServiceAlerts.TranslatedString.Builder builderTS = ServiceAlerts.TranslatedString.newBuilder();
        ServiceAlerts.TranslatedString.Translation.Builder translation = ServiceAlerts.TranslatedString.Translation.newBuilder();
        String lang = input.get(0).getLang();
        if (lang == null) {
            translation.setLanguage("en");
        } else {
            translation.setLanguage(lang);
        }
        String txt = input.get(0).getValue();
        if (txt == null) {
            return null;
        }
        translation.setText(txt);
        builderTS.addTranslation(translation);
        return builderTS.build();
    }

    private static ServiceAlerts.Id normalizeToId(String defaultAgencyId, String id) {
        if (id == null) {
            return null;
        }
        ServiceAlerts.Id.Builder builder = ServiceAlerts.Id.newBuilder();
        if (id.contains("_")) {
            AgencyAndId agencyAndId = AgencyAndIdLibrary.convertFromString((String)id);
            builder.setAgencyId(agencyAndId.getAgencyId());
            builder.setId(agencyAndId.getId());
        } else {
            builder.setAgencyId(defaultAgencyId);
            builder.setId(id);
        }
        return builder.build();
    }

    public static void fillTranslations(List<NaturalLanguageStringBean> input, GtfsRealtime.TranslatedString.Builder output) {
        if (input != null) {
            for (NaturalLanguageStringBean nls : input) {
                GtfsRealtime.TranslatedString.Translation.Builder translation = output.addTranslationBuilder();
                translation.setText(nls.getValue());
                if (nls.getLang() == null) continue;
                translation.setLanguage(nls.getLang());
            }
        }
    }

    protected static String normalizeId(String id) {
        int index;
        if (REMOVE_AGENCY_ID && (index = id.indexOf(95)) != -1) {
            id = id.substring(index + 1);
        }
        return id;
    }

    protected static AgencyAndId modifiedStopId(String agency, String stopId) {
        AgencyAndId id = AgencyAndId.convertFromString((String)stopId);
        return id;
    }
}

