/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.onebusaway.alerts.impl.ServiceAlertLocalizedString;
import org.onebusaway.alerts.impl.ServiceAlertSituationConsequenceClause;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.transit_data.model.service_alerts.ECause;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;

@Entity
@Table(name="transit_data_service_alerts_records")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ServiceAlertRecord {
    public static final String INTERNAL_SOURCE = "oba";
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="servicealert_active_window_id", referencedColumnName="id")
    private Set<ServiceAlertTimeRange> activeWindows = new HashSet<ServiceAlertTimeRange>();
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="servicealert_publication_window_id", referencedColumnName="id")
    private Set<ServiceAlertTimeRange> publicationWindows = new HashSet<ServiceAlertTimeRange>();
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="servicealert_summary_id", referencedColumnName="id")
    private Set<ServiceAlertLocalizedString> summaries = new HashSet<ServiceAlertLocalizedString>();
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="servicealert_description_id", referencedColumnName="id")
    private Set<ServiceAlertLocalizedString> descriptions = new HashSet<ServiceAlertLocalizedString>();
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="servicealert_url_id", referencedColumnName="id")
    private Set<ServiceAlertLocalizedString> urls = new HashSet<ServiceAlertLocalizedString>();
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="serviceAlertRecord_id", referencedColumnName="id")
    private Set<ServiceAlertsSituationAffectsClause> allAffects = new HashSet<ServiceAlertsSituationAffectsClause>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="serviceAlertRecord_id", referencedColumnName="id")
    private Set<ServiceAlertSituationConsequenceClause> consequences = new HashSet<ServiceAlertSituationConsequenceClause>();
    @Enumerated(value=EnumType.STRING)
    private ESeverity severity;
    @Enumerated(value=EnumType.STRING)
    private ECause cause;
    private String source = "oba";
    @Id
    @GeneratedValue
    private int id = 0;
    @Column(nullable=false, name="service_alert_agency_id", length=50)
    private String agencyId;
    @Column(nullable=false, name="service_alert_id", length=255)
    private String serviceAlertId;
    @Column(nullable=true, name="consequence_message", length=50)
    private String consequenceMessage;
    private Boolean copy;
    private Long creationTime = 0L;
    private Long modifiedTime = 0L;

    public Long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(long modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public Set<ServiceAlertTimeRange> getActiveWindows() {
        return this.activeWindows;
    }

    public void setActiveWindows(Set<ServiceAlertTimeRange> activeWindows) {
        this.activeWindows = activeWindows;
    }

    public Set<ServiceAlertTimeRange> getPublicationWindows() {
        return this.publicationWindows;
    }

    public void setPublicationWindows(Set<ServiceAlertTimeRange> publicationWindows) {
        this.publicationWindows = publicationWindows;
    }

    public Set<ServiceAlertLocalizedString> getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Set<ServiceAlertLocalizedString> summaries) {
        this.summaries = summaries;
    }

    public Set<ServiceAlertLocalizedString> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Set<ServiceAlertLocalizedString> descriptions) {
        this.descriptions = descriptions;
    }

    public Set<ServiceAlertLocalizedString> getUrls() {
        return this.urls;
    }

    public void setUrls(Set<ServiceAlertLocalizedString> urls) {
        this.urls = urls;
    }

    public Set<ServiceAlertsSituationAffectsClause> getAllAffects() {
        return this.allAffects;
    }

    public void setAllAffects(Set<ServiceAlertsSituationAffectsClause> allAffects) {
        this.allAffects = allAffects;
    }

    public Set<ServiceAlertSituationConsequenceClause> getConsequences() {
        return this.consequences;
    }

    public void setConsequences(Set<ServiceAlertSituationConsequenceClause> consequences) {
        this.consequences = consequences;
    }

    public ESeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(ESeverity severity) {
        this.severity = severity;
    }

    public ECause getCause() {
        return this.cause;
    }

    public void setCause(ECause cause) {
        this.cause = cause;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getConsequenceMessage() {
        return this.consequenceMessage;
    }

    public void setConsequenceMessage(String consequenceMessage) {
        this.consequenceMessage = consequenceMessage;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public String getServiceAlertId() {
        return this.serviceAlertId;
    }

    public void setServiceAlertId(String serviceAlertId) {
        this.serviceAlertId = serviceAlertId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Boolean isCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public int hashCode() {
        return Objects.hash(this.id) + Objects.hash(this.agencyId) + Objects.hash(this.serviceAlertId) + Objects.hash(this.consequenceMessage) + Objects.hash(this.copy) + Objects.hash(this.creationTime) + Objects.hash(this.modifiedTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAlertRecord sar = (ServiceAlertRecord)o;
        return Objects.equals(this.id, sar.id) && Objects.equals(this.agencyId, sar.agencyId) && Objects.equals(this.serviceAlertId, sar.serviceAlertId) && Objects.equals(this.consequenceMessage, sar.consequenceMessage) && Objects.equals(this.copy, sar.copy) && Objects.equals(this.creationTime, sar.creationTime) && Objects.equals(this.modifiedTime, sar.modifiedTime);
    }

    public String toString() {
        return "ServiceAlertRecord{" + this.id + "}";
    }
}

