/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cli;

import com.sun.akuma.CLibrary;
import com.sun.akuma.Daemon;
import com.sun.akuma.JavaVMArguments;
import com.sun.jna.StringArray;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Daemonizer {
    private static final String ARG_DAEMONIZE = "daemonize";
    private static final String ARG_PID_FILE = "pidFile";
    private static final String ARG_JVM_ARGS = "jvmArgs";
    private static final String ARG_ERROR_FILE = "errorFile";
    private static final String ARG_OUTPUT_FILE = "outputFile";
    private static final String ARG_EXE = "exe";
    private static MyLog _log = new MyLog();
    private File _outputFile;
    private File _errorFile;
    private File _pidFile;
    private File _workingDirectory;
    private String _exe;
    private Collection<String> _jvmArgs;

    public static Options buildOptions(Options options) {
        options.addOption(ARG_JVM_ARGS, true, "custom jvm args for the daemon");
        options.addOption(ARG_OUTPUT_FILE, true, "stdout output (&2 to redirect to stderr)");
        options.addOption(ARG_ERROR_FILE, true, "stderr output (&1 to redirect to stdout)");
        options.addOption(ARG_PID_FILE, true, "pid file");
        options.addOption(ARG_EXE, true, "specify exe path");
        options.addOption(ARG_DAEMONIZE, false, "run as a daemon");
        return options;
    }

    public static boolean handleDaemonization(CommandLine cli) throws Exception {
        if (cli.hasOption(ARG_DAEMONIZE)) {
            _log.debug("-daemonize option specified");
            Daemonizer daemonizer = new Daemonizer();
            if (cli.hasOption(ARG_OUTPUT_FILE)) {
                daemonizer.setOutputFile(new File(cli.getOptionValue(ARG_OUTPUT_FILE)));
            }
            if (cli.hasOption(ARG_ERROR_FILE)) {
                daemonizer.setErrorFile(new File(cli.getOptionValue(ARG_ERROR_FILE)));
            }
            if (cli.hasOption(ARG_PID_FILE)) {
                daemonizer.setPidFile(new File(cli.getOptionValue(ARG_PID_FILE)));
            }
            if (cli.hasOption(ARG_JVM_ARGS)) {
                String[] jvmArgs = cli.getOptionValue(ARG_JVM_ARGS).split(" ");
                daemonizer.setJvmArgs(Arrays.asList(jvmArgs));
            }
            if (cli.hasOption(ARG_EXE)) {
                daemonizer.setExe(cli.getOptionValue(ARG_EXE));
            }
            daemonizer.daemonize();
            return true;
        }
        return false;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void setErrorFile(File errorFile) {
        this._errorFile = errorFile;
    }

    public void setPidFile(File pidFile) {
        this._pidFile = pidFile;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this._workingDirectory = workingDirectory;
    }

    public void setJvmArgs(Collection<String> jvmArgs) {
        this._jvmArgs = jvmArgs;
    }

    private void setExe(String exe) {
        this._exe = exe;
    }

    public void daemonize() throws Exception {
        DaemonImpl d = new DaemonImpl();
        if (d.isDaemonized()) {
            if (_log.isDebugEnabled()) {
                _log.debug("process is already daemonized");
                _log.debug("currentExecutabe=" + Daemon.getCurrentExecutable());
                Properties props = System.getProperties();
                for (Object key : props.keySet()) {
                    Object value = props.get(key);
                    _log.debug(key + "," + value);
                }
            }
            _log.debug("pre complete");
            CLibrary.LIBC.umask(23);
            _log.debug("umask complete");
            if (this._pidFile == null) {
                d.init(null);
            } else {
                d.init(this._pidFile.getAbsolutePath());
            }
            _log.debug("init complete");
        } else {
            _log.debug("forking daemon process");
            JavaVMArguments arguments = JavaVMArguments.current();
            if (this._jvmArgs != null) {
                arguments.addAll(1, this._jvmArgs);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("jvm args:");
                for (int i = 0; i < arguments.size(); ++i) {
                    _log.debug((String)arguments.get(i));
                }
                _log.debug("currentExecutabe=" + Daemon.getCurrentExecutable());
            }
            d.daemonize(arguments);
            System.exit(0);
        }
    }

    private boolean isRedirectOutputToError() {
        if (this._outputFile == null || this._errorFile == null) {
            return false;
        }
        return this._outputFile.getName().equals("&2");
    }

    private boolean isRedirectErrorToOutput() {
        if (this._outputFile == null || this._errorFile == null) {
            return false;
        }
        return this._errorFile.getName().equals("&1");
    }

    private static class MyLog {
        private MyLog() {
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void debug(String string) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter("/tmp/log.out", true));
                out.println(string);
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private class DaemonImpl
    extends Daemon {
        private DaemonImpl() {
        }

        protected void chdirToRoot() {
            super.chdirToRoot();
            if (Daemonizer.this._workingDirectory != null) {
                CLibrary.LIBC.chdir(Daemonizer.this._workingDirectory.getAbsolutePath());
                System.setProperty("user.dir", Daemonizer.this._workingDirectory.getAbsolutePath());
            }
        }

        protected void closeDescriptors() throws IOException {
            boolean redirectOutputToError = Daemonizer.this.isRedirectOutputToError();
            boolean redirectErrorToOutput = Daemonizer.this.isRedirectErrorToOutput();
            if (redirectOutputToError && redirectErrorToOutput) {
                throw new IllegalStateException("circular redirection amongst output and error");
            }
            super.closeDescriptors();
            if (redirectErrorToOutput) {
                PrintStream stream = new PrintStream(new FileOutputStream(Daemonizer.this._outputFile, true));
                System.setOut(stream);
                System.setErr(stream);
            } else if (redirectOutputToError) {
                PrintStream stream = new PrintStream(new FileOutputStream(Daemonizer.this._errorFile, true));
                System.setOut(stream);
                System.setErr(stream);
            } else {
                if (Daemonizer.this._outputFile != null) {
                    System.setOut(new PrintStream(new FileOutputStream(Daemonizer.this._outputFile, true)));
                }
                if (Daemonizer.this._errorFile != null) {
                    System.setErr(new PrintStream(new FileOutputStream(Daemonizer.this._errorFile, true)));
                }
            }
        }

        public void daemonize(JavaVMArguments args) {
            if (this.isDaemonized()) {
                throw new IllegalStateException("Already running as a daemon");
            }
            args.setSystemProperty(Daemon.class.getName(), "daemonized");
            String exe = DaemonImpl.getCurrentExecutable();
            if (Daemonizer.this._exe != null) {
                exe = Daemonizer.this._exe;
            }
            StringArray sa = new StringArray((String[])args.toArray((Object[])new String[args.size()]));
            int i = CLibrary.LIBC.fork();
            if (i < 0) {
                CLibrary.LIBC.perror("initial fork failed");
                System.exit(-1);
            }
            if (i == 0) {
                CLibrary.LIBC.execv(exe, sa);
                System.err.println("exec failed");
                CLibrary.LIBC.perror("initial exec failed");
                System.exit(-1);
            }
        }
    }
}

