/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ObaSecurityHeaderFilter
implements Filter {
    public static final String CONTENT_SECURITY_POLICY_OPTION = "contentSecurityPolicyOption";
    public static final String CSP_FRAME_ANCESTORS_HOST_SUB_OPTION = "cspFrameHostSubOption";
    public static final String CSP_NONE_SUB_OPTION = "cspNoneSubOption";
    public static final String CSP_SELF_SUB_OPTION = "cspSelfSubOption";
    private static final String CSPS_HEADER = "Content-Security-Policy";
    private static final String CSPS_PRE_AMBLE = "frame-ancestors ";
    private static final String CSPS_SELF = "'self'";
    private static final String CSPS_NONE = "'none'";
    private Map<String, String> headerMap = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(CONTENT_SECURITY_POLICY_OPTION) != null) {
            if (filterConfig.getInitParameter(CSP_FRAME_ANCESTORS_HOST_SUB_OPTION) != null) {
                this.headerMap.put(CSPS_HEADER, "frame-ancestors '" + filterConfig.getInitParameter(CSP_FRAME_ANCESTORS_HOST_SUB_OPTION) + "'");
            } else if (filterConfig.getInitParameter(CSPS_NONE) != null) {
                this.headerMap.put(CSPS_HEADER, "frame-ancestors 'none'");
            } else {
                this.headerMap.put(CSPS_HEADER, "frame-ancestors 'self'");
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response.isCommitted() && !this.headerMap.isEmpty()) {
            throw new ServletException("Response is committed when adding headers " + this.headerMap.toString());
        }
        if (!this.headerMap.isEmpty() && response instanceof HttpServletResponse) {
            for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                ((HttpServletResponse)response).setHeader(entry.getKey(), entry.getValue());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

